/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.stream;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedStream;
import java.io.InputStream;
import java.util.List;
import java.util.function.Supplier;
import org.drasyl.handler.stream.ChunkedMessageInput;
import org.drasyl.util.Preconditions;
import org.drasyl.util.logging.Logger;
import org.drasyl.util.logging.LoggerFactory;

public class LargeByteBufToChunkedMessageEncoder
extends MessageToMessageEncoder<ByteBuf> {
    private static final Logger LOG = LoggerFactory.getLogger(LargeByteBufToChunkedMessageEncoder.class);
    private final int maxChunkLength;
    private final int maxContentLength;

    public LargeByteBufToChunkedMessageEncoder(int maxChunkLength, int maxContentLength) {
        this.maxChunkLength = Preconditions.requirePositive((int)maxChunkLength);
        this.maxContentLength = Preconditions.requirePositive((int)maxContentLength);
    }

    public boolean acceptOutboundMessage(Object msg) {
        return msg instanceof ByteBuf && ((ByteBuf)msg).readableBytes() > this.maxChunkLength;
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        int contentLength = msg.readableBytes();
        if (contentLength > this.maxContentLength) {
            throw new EncoderException("ByteBuf has a size of " + contentLength + " bytes and is too large. The max. allowed size is " + this.maxContentLength + " bytes. ByteBuf dropped.");
        }
        LOG.trace("ByteBuf has a size of {} bytes and is therefore split into {} chunks of max. {} bytes.", new Supplier[]{() -> contentLength, () -> (int)Math.ceil((double)contentLength / (double)this.maxChunkLength), () -> this.maxChunkLength});
        out.add(new ChunkedMessageInput((ChunkedInput<ByteBuf>)new ChunkedStream((InputStream)new ByteBufInputStream(msg.retain(), true), this.maxChunkLength)));
    }
}

