/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.stream;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.DefaultByteBufHolder;
import java.util.Objects;

public class MessageChunk
extends DefaultByteBufHolder {
    private final byte msgId;
    private final int chunkNo;

    public MessageChunk(byte msgId, int chunkNo, ByteBuf content) {
        super(content);
        this.msgId = msgId;
        this.chunkNo = chunkNo;
    }

    public String toString() {
        return "MessageChunk{msgId=" + this.msgId + ", chunkNo=" + this.chunkNo + ", content=" + this.content() + "}";
    }

    public byte msgId() {
        return this.msgId;
    }

    public int chunkNo() {
        return this.chunkNo;
    }

    public MessageChunk replace(ByteBuf content) {
        return new MessageChunk(this.msgId, this.chunkNo, content);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.msgId, this.chunkNo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MessageChunk that = (MessageChunk)((Object)o);
        return this.msgId == that.msgId && Objects.equals(this.chunkNo, that.chunkNo);
    }
}

