/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.util;

import java.util.BitSet;
import java.util.Collection;
import java.util.function.Function;
import org.drasyl.util.BloomFilter;
import org.drasyl.util.Preconditions;

public class CountingBloomFilter<E>
extends BloomFilter<E> {
    private final int countingBits;

    protected CountingBloomFilter(BloomFilter.Parameters parameters, Function<E, byte[]> bytesSupplier, BitSet bitSet, int countingBits) {
        super(parameters, bytesSupplier, bitSet);
        this.countingBits = Preconditions.requirePositive((int)countingBits);
    }

    protected CountingBloomFilter(BloomFilter.Parameters parameters, Function<E, byte[]> bytesSupplier, int countingBits) {
        this(parameters, bytesSupplier, new BitSet(parameters.m * countingBits), countingBits);
    }

    public CountingBloomFilter(int n, double p, int m, int k, Function<E, byte[]> bytesSupplier, BitSet bitSet, int countingBits) {
        this(new BloomFilter.Parameters(n, p, m, k), bytesSupplier, bitSet, countingBits);
    }

    public CountingBloomFilter(int n, double p, int m, int k, Function<E, byte[]> bytesSupplier, int countingBits) {
        this(new BloomFilter.Parameters(n, p, m, k), bytesSupplier, countingBits);
    }

    public CountingBloomFilter(int n, double p, int m, int k, Function<E, byte[]> bytesSupplier, BitSet bitSet) {
        this(new BloomFilter.Parameters(n, p, m, k), bytesSupplier, bitSet, 16);
    }

    public CountingBloomFilter(int n, double p, int m, int k, Function<E, byte[]> bytesSupplier) {
        this(new BloomFilter.Parameters(n, p, m, k), bytesSupplier, 16);
    }

    public CountingBloomFilter(int n, double p, Function<E, byte[]> bytesSupplier, int countingBits) {
        this(new BloomFilter.Parameters(n, p, 0, 0), bytesSupplier, countingBits);
    }

    public CountingBloomFilter(int n, double p, Function<E, byte[]> bytesSupplier) {
        this(new BloomFilter.Parameters(n, p, 0, 0), bytesSupplier, 16);
    }

    public CountingBloomFilter(int n, double p, Function<E, byte[]> bytesSupplier, BitSet bitSet) {
        this(new BloomFilter.Parameters(n, p, 0, 0), bytesSupplier, bitSet, 16);
    }

    @Override
    public String toString() {
        return "CountingBloomFilter{n=" + this.parameters.n + ", p=" + this.parameters.p + ", m=" + this.parameters.m + ", k=" + this.parameters.k + ", countingBits=" + this.countingBits + "}";
    }

    @Override
    public boolean remove(Object o) {
        try {
            int[] hashes;
            boolean modified = false;
            for (int hash : hashes = this.hashes(o)) {
                if (!this.unsetBit(hash)) continue;
                modified = true;
            }
            return modified;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object e : c) {
            if (!this.remove(e)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public void merge(BloomFilter<E> other) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean getBit(int index) {
        BitSet countingBitSet = this.bitSet.get(index, index + this.countingBits);
        return !countingBitSet.isEmpty();
    }

    @Override
    protected boolean setBit(int index) {
        for (int i = 0; i < this.countingBits; ++i) {
            boolean bit = this.bitSet.get(index + i);
            if (!bit) {
                this.bitSet.set(index + i, true);
                break;
            }
            if (i == this.countingBits - 1) {
                throw new IllegalStateException("Counter overflow detected. Bloom filter corrupted.");
            }
            this.bitSet.set(index + i, false);
        }
        return true;
    }

    protected boolean unsetBit(int index) {
        for (int i = 0; i < this.countingBits; ++i) {
            boolean bit = this.bitSet.get(index + i);
            if (bit) {
                this.bitSet.set(index + i, false);
                break;
            }
            if (i == this.countingBits - 1) {
                throw new IllegalStateException("counter underflow detected. Bloom filter corrupted.");
            }
            this.bitSet.set(index + i, true);
        }
        return true;
    }
}

