/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.util;

import com.sun.jna.Platform;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.function.Function;
import org.drasyl.util.logging.Logger;
import org.drasyl.util.logging.LoggerFactory;

public final class OSInfo {
    private static final Logger LOG = LoggerFactory.getLogger(OSInfo.class);
    private static final String UNKNOWN = "unknown";
    static volatile boolean lock;
    private final String osName = OSInfo.detectOSName();
    private final String osVersion = OSInfo.detectOSVersion();
    private final String osArch = OSInfo.detectOSArch();
    private final String currentUser = OSInfo.detectCurrentUser();
    private final String hostname = OSInfo.detectHostname();
    private final int availableProcessors = OSInfo.detectAvailableProcessors();
    private final String cpuName = OSInfo.detectCPUName();
    private final long totalMemory = OSInfo.detectTotalMemory();

    private OSInfo() {
    }

    public static OSInfo getInstance() {
        return LazyOSInfoHolder.INSTANCE;
    }

    private static String detectHostname() {
        String val;
        try {
            InetAddress localMachine = InetAddress.getLocalHost();
            val = localMachine.getHostName();
            LOG.debug("Hostname: {}", (Object)val);
        }
        catch (UnknownHostException e) {
            val = "localhost";
        }
        return val;
    }

    private static int detectAvailableProcessors() {
        int val = Runtime.getRuntime().availableProcessors();
        LOG.debug("Available processors: {}", () -> val);
        return val;
    }

    private static long detectTotalMemory() {
        long val = Runtime.getRuntime().maxMemory();
        try {
            if (Platform.isWindows()) {
                String[] commands = new String[]{"cmd", "/c", "wmic ComputerSystem get TotalPhysicalMemory | findstr [0..9]"};
                val = OSInfo.commandDetectionHelper(commands, Long::parseLong);
            } else if (Platform.isMac()) {
                String[] commands = new String[]{"system_profiler", "SPHardwareDataType"};
                val = OSInfo.commandDetectionHelper(commands, s -> {
                    if (s.startsWith("Memory:")) {
                        s = s.replace("Memory", "");
                        s = s.replace(":", "");
                        s = s.replace(" ", "");
                        s = s.replace("GB", "");
                        return Long.parseLong(s) * 0x40000000L;
                    }
                    return null;
                });
            } else if (Platform.isLinux()) {
                String[] commands = new String[]{"/bin/bash", "-c", "cat /proc/meminfo | grep MemTotal"};
                val = OSInfo.commandDetectionHelper(commands, s -> {
                    if (s.startsWith("MemTotal")) {
                        s = s.replace("MemTotal", "");
                        s = s.replace(":", "");
                        s = s.replace("kB", "");
                        s = s.replace(" ", "");
                        return Long.parseLong(s) * 1024L;
                    }
                    return null;
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        LOG.debug("Total memory: {} bytes", (Object)val);
        return val;
    }

    private static <R> R commandDetectionHelper(String[] commands, Function<String, R> matcher) throws IOException {
        Runtime rt = Runtime.getRuntime();
        Process proc = rt.exec(commands);
        BufferedReader stdError = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        String s = stdError.readLine();
        if (s != null) {
            throw new IOException(s);
        }
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        while ((s = stdInput.readLine()) != null) {
            R result = matcher.apply(s = s.trim());
            if (result == null) continue;
            return result;
        }
        throw new IOException();
    }

    public String osName() {
        return this.osName;
    }

    public String osVersion() {
        return this.osVersion;
    }

    public String osArch() {
        return this.osArch;
    }

    public String currentUser() {
        return this.currentUser;
    }

    public String hostname() {
        return this.hostname;
    }

    public int availableProcessors() {
        return this.availableProcessors;
    }

    public long totalMemory() {
        return this.totalMemory;
    }

    public String cpuName() {
        return this.cpuName;
    }

    private static String detectOSName() {
        String val = System.getProperty("os.name", UNKNOWN);
        LOG.debug("OS name: {}", () -> val);
        return val;
    }

    private static String detectOSVersion() {
        String val = System.getProperty("os.version", UNKNOWN);
        LOG.debug("OS version: {}", () -> val);
        return val;
    }

    private static String detectOSArch() {
        String val = Platform.ARCH;
        LOG.debug("OS arch: {}", () -> val);
        return val;
    }

    private static String detectCurrentUser() {
        String val = System.getProperty("user.name", UNKNOWN);
        LOG.debug("Current user: {}", () -> val);
        return val;
    }

    private static String detectCPUName() {
        String val = UNKNOWN;
        try {
            if (Platform.isWindows()) {
                String[] commands = new String[]{"cmd", "/c", "wmic CPU get NAME | findstr [A-Za-z]"};
                val = OSInfo.commandDetectionHelper(commands, s -> {
                    if (!s.startsWith("Name") && !s.isEmpty()) {
                        return s;
                    }
                    return null;
                });
            } else if (Platform.isMac()) {
                String[] commands = new String[]{"system_profiler", "SPHardwareDataType"};
                val = OSInfo.commandDetectionHelper(commands, s -> {
                    if (s.startsWith("Chip:")) {
                        s = s.replace("Chip", "");
                        s = s.replace(":", "");
                        s = s.trim();
                        return s;
                    }
                    return null;
                });
            } else if (Platform.isLinux()) {
                String[] commands = new String[]{"/bin/bash", "-c", "cat /proc/cpuinfo | grep \"model name\""};
                val = OSInfo.commandDetectionHelper(commands, s -> {
                    if (s.startsWith("model name")) {
                        s = s.replace("model name", "");
                        s = s.replace(":", "");
                        s = s.trim();
                        return s;
                    }
                    return null;
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        LOG.debug("CPU name: {}", (Object)val);
        return val;
    }

    private static final class LazyOSInfoHolder {
        static final OSInfo INSTANCE = new OSInfo();
        static final boolean LOCK;

        private LazyOSInfoHolder() {
        }

        static {
            lock = true;
            LOCK = true;
        }
    }
}

