/*
 * Decompiled with CFR 0.152.
 */
package kjob.inmem;

import java.time.Clock;
import kjob.core.BaseKJob;
import kjob.core.repository.JobRepository;
import kjob.core.repository.LockRepository;
import kjob.inmem.repository.InMemJobRepository;
import kjob.inmem.repository.InMemLockRepository;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lkjob/inmem/InMemKJob;", "Lkjob/core/BaseKJob;", "Lkjob/inmem/InMemKJob$Configuration;", "config", "(Lkjob/inmem/InMemKJob$Configuration;)V", "jobRepository", "Lkjob/core/repository/JobRepository;", "getJobRepository", "()Lkjob/core/repository/JobRepository;", "lockRepository", "Lkjob/core/repository/LockRepository;", "getLockRepository", "()Lkjob/core/repository/LockRepository;", "Configuration", "kjob-inmem"})
public final class InMemKJob
extends BaseKJob<Configuration> {
    @NotNull
    private final JobRepository jobRepository;
    @NotNull
    private final LockRepository lockRepository;

    public InMemKJob(@NotNull Configuration config) {
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        super((BaseKJob.Configuration)config);
        Clock clock = Clock.systemUTC();
        Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"systemUTC()");
        this.jobRepository = new InMemJobRepository(clock);
        Clock clock2 = Clock.systemUTC();
        Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC()");
        this.lockRepository = new InMemLockRepository(config, clock2);
    }

    @NotNull
    public JobRepository getJobRepository() {
        return this.jobRepository;
    }

    @NotNull
    public LockRepository getLockRepository() {
        return this.lockRepository;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lkjob/inmem/InMemKJob$Configuration;", "Lkjob/core/BaseKJob$Configuration;", "()V", "expireLockInMinutes", "", "getExpireLockInMinutes", "()J", "setExpireLockInMinutes", "(J)V", "kjob-inmem"})
    public static final class Configuration
    extends BaseKJob.Configuration {
        private long expireLockInMinutes = 5L;

        public final long getExpireLockInMinutes() {
            return this.expireLockInMinutes;
        }

        public final void setExpireLockInMinutes(long l) {
            this.expireLockInMinutes = l;
        }
    }
}

