/*
 * Decompiled with CFR 0.152.
 */
package kjob.inmem.repository;

import java.time.Clock;
import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kjob.core.job.Lock;
import kjob.core.repository.LockRepository;
import kjob.inmem.InMemKJob;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B(\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\u0010\tB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\r\u0010\u000f\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0010J\u0019\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u0019\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\rH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Lkjob/inmem/repository/InMemLockRepository;", "Lkjob/core/repository/LockRepository;", "clock", "Ljava/time/Clock;", "conf", "Lkotlin/Function1;", "Lkjob/inmem/InMemKJob$Configuration;", "", "Lkotlin/ExtensionFunctionType;", "(Ljava/time/Clock;Lkotlin/jvm/functions/Function1;)V", "(Lkjob/inmem/InMemKJob$Configuration;Ljava/time/Clock;)V", "map", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lkjob/core/job/Lock;", "deleteAll", "deleteAll$kjob_inmem", "exists", "", "id", "(Ljava/util/UUID;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ping", "kjob-inmem"})
public final class InMemLockRepository
implements LockRepository {
    @NotNull
    private final InMemKJob.Configuration conf;
    @NotNull
    private final Clock clock;
    @NotNull
    private final ConcurrentHashMap<UUID, Lock> map;

    public InMemLockRepository(@NotNull InMemKJob.Configuration conf, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)((Object)conf), (String)"conf");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.conf = conf;
        this.clock = clock;
        this.map = new ConcurrentHashMap();
    }

    public InMemLockRepository(@NotNull Clock clock, @NotNull Function1<? super InMemKJob.Configuration, Unit> conf) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter(conf, (String)"conf");
        InMemKJob.Configuration configuration = new InMemKJob.Configuration();
        conf.invoke((Object)configuration);
        this(configuration, clock);
    }

    @Nullable
    public Object ping(@NotNull UUID id, @NotNull Continuation<? super Lock> $completion) {
        Lock lock = this.map.compute(id, (arg_0, arg_1) -> InMemLockRepository.ping$lambda$0((Function2)new Function2<UUID, Lock, Lock>(id, this){
            final /* synthetic */ UUID $id;
            final /* synthetic */ InMemLockRepository this$0;
            {
                this.$id = $id;
                this.this$0 = $receiver;
                super(2);
            }

            @Nullable
            public final Lock invoke(@NotNull UUID uUID, @Nullable Lock lock) {
                Intrinsics.checkNotNullParameter((Object)uUID, (String)"<anonymous parameter 0>");
                Instant instant = Instant.now(InMemLockRepository.access$getClock$p(this.this$0));
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(clock)");
                return new Lock(this.$id, instant);
            }
        }, arg_0, arg_1));
        if (lock == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return lock;
    }

    @Nullable
    public Object exists(@NotNull UUID id, @NotNull Continuation<? super Boolean> $completion) {
        Lock lock = this.map.get(id);
        return Boxing.boxBoolean((lock == null || lock.getUpdatedAt().plusSeconds(this.conf.getExpireLockInMinutes() * (long)60).isAfter(Instant.now(this.clock)) ? 1 : 0) != 0);
    }

    public final void deleteAll$kjob_inmem() {
        this.map.clear();
    }

    private static final Lock ping$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Lock)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ Clock access$getClock$p(InMemLockRepository $this) {
        return $this.clock;
    }
}

