/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import org.drizzle.jdbc.DrizzleConnection;
import org.drizzle.jdbc.JDBCUrl;
import org.drizzle.jdbc.internal.SQLExceptionMapper;
import org.drizzle.jdbc.internal.common.QueryException;
import org.drizzle.jdbc.internal.common.query.DrizzleQueryFactory;
import org.drizzle.jdbc.internal.mysql.MySQLProtocol;

public final class DrizzleDriver
implements Driver {
    private static final Logger log = Logger.getLogger(DrizzleDriver.class.getName());

    public Connection connect(String url, Properties info) throws SQLException {
        String baseUrl = url;
        int idx = url.lastIndexOf("?");
        if (idx > 0) {
            baseUrl = url.substring(0, idx);
            String urlParams = url.substring(idx + 1);
            this.setURLParameters(urlParams, info);
        }
        log.finest("Connecting to: " + url);
        try {
            JDBCUrl jdbcUrl = JDBCUrl.parse(baseUrl);
            if (jdbcUrl == null) {
                return null;
            }
            String userName = info.getProperty("user", jdbcUrl.getUsername());
            String password = info.getProperty("password", jdbcUrl.getPassword());
            MySQLProtocol protocol = new MySQLProtocol(jdbcUrl.getHostname(), jdbcUrl.getPort(), jdbcUrl.getDatabase(), userName, password, info);
            return new DrizzleConnection(protocol, new DrizzleQueryFactory());
        }
        catch (QueryException e) {
            throw SQLExceptionMapper.get(e);
        }
    }

    private void setURLParameters(String urlParameters, Properties info) {
        String[] parameters;
        for (String param : parameters = urlParameters.split("&")) {
            String[] keyVal = param.split("=");
            info.setProperty(keyVal[0], keyVal[1]);
        }
    }

    public boolean acceptsURL(String url) {
        return url.startsWith("jdbc:drizzle://") || url.startsWith("jdbc:mysql:thin://");
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        return 0;
    }

    public int getMinorVersion() {
        return 1;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            DriverManager.registerDriver(new DrizzleDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not register driver", e);
        }
    }
}

