/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc;

public class JDBCUrl {
    private final DBType dbType;
    private final String username;
    private final String password;
    private final String hostname;
    private final int port;
    private final String database;

    private JDBCUrl(DBType dbType, String username, String password, String hostname, int port, String database) {
        this.dbType = dbType;
        this.username = username;
        this.password = password;
        this.hostname = hostname;
        this.port = port;
        this.database = database;
    }

    public static JDBCUrl parse(String url) {
        String hostname;
        DBType dbType;
        if (url.startsWith("jdbc:mysql:thin://")) {
            dbType = DBType.MYSQL;
            url = url.substring("jdbc:mysql:thin://".length());
        } else if (url.startsWith("jdbc:drizzle://")) {
            dbType = DBType.DRIZZLE;
            url = url.substring("jdbc:drizzle://".length());
        } else {
            return null;
        }
        int port = dbType == DBType.DRIZZLE ? 3306 : 3306;
        String username = "";
        String password = "";
        int atSignIndex = url.indexOf("@");
        if (atSignIndex != -1) {
            String userPassCombo = url.substring(0, atSignIndex);
            url = url.substring(atSignIndex + 1);
            int userPassDividerIndex = userPassCombo.indexOf(":");
            if (userPassDividerIndex == -1) {
                username = userPassCombo;
            } else {
                username = userPassCombo.substring(0, userPassDividerIndex);
                password = userPassCombo.substring(userPassDividerIndex + 1);
            }
        }
        int slashIndex = url.indexOf("/");
        String hostPortCombo = url.substring(0, slashIndex);
        url = url.substring(slashIndex + 1);
        int ipv6StartIndex = hostPortCombo.indexOf("[");
        int ipv6EndIndex = hostPortCombo.indexOf("]");
        if (ipv6StartIndex >= 0 && ipv6EndIndex > ipv6StartIndex) {
            hostname = hostPortCombo.substring(ipv6StartIndex + 1, ipv6EndIndex);
            int hostPortDividerIndex = hostPortCombo.indexOf(":", ipv6EndIndex + 1);
            if (hostPortDividerIndex != -1) {
                port = Integer.parseInt(hostPortCombo.substring(hostPortDividerIndex + 1));
            }
        } else {
            int hostPortDividerIndex = hostPortCombo.indexOf(":");
            if (hostPortDividerIndex == -1) {
                hostname = hostPortCombo;
            } else {
                hostname = hostPortCombo.substring(0, hostPortDividerIndex);
                port = Integer.parseInt(hostPortCombo.substring(hostPortDividerIndex + 1));
            }
        }
        slashIndex = url.indexOf("/");
        String database = slashIndex == -1 ? url : url.substring(0, slashIndex);
        return new JDBCUrl(dbType, username, password, hostname, port, database);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getDatabase() {
        return this.database;
    }

    public DBType getDBType() {
        return this.dbType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DBType {
        DRIZZLE,
        MYSQL;

    }
}

