/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.drizzle.jdbc.internal.common.ParameterizedBatchHandler;
import org.drizzle.jdbc.internal.common.Protocol;
import org.drizzle.jdbc.internal.common.QueryException;
import org.drizzle.jdbc.internal.common.query.DrizzleQuery;
import org.drizzle.jdbc.internal.common.query.ParameterizedQuery;
import org.drizzle.jdbc.internal.common.query.parameters.ParameterHolder;

public class RewriteParameterizedBatchHandler
implements ParameterizedBatchHandler {
    private static final Logger log = Logger.getLogger(RewriteParameterizedBatchHandler.class.getName());
    private final int MAX_QUERY_LENGTH = 1000000;
    private final String baseQuery;
    private final String queryValuePart;
    private final Protocol protocol;
    private final List<String> queriesToSend = new LinkedList<String>();
    private StringBuilder queryBuilder = new StringBuilder();
    private boolean firstWritten = false;
    private int queryCount = 0;
    private final String onDupKeyPart;

    public RewriteParameterizedBatchHandler(Protocol protocol, String baseQuery, String queryValuePart, String onDupKeyPart) {
        this.baseQuery = baseQuery;
        this.queryValuePart = queryValuePart;
        this.onDupKeyPart = onDupKeyPart == null ? "" : onDupKeyPart;
        this.queryBuilder.append(baseQuery);
        this.protocol = protocol;
    }

    public void addToBatch(ParameterizedQuery query) {
        ParameterHolder[] parameters = query.getParameters();
        StringBuilder replacedValuePart = new StringBuilder();
        int questionMarkPosition = 0;
        for (int i = 0; i < this.queryValuePart.length(); ++i) {
            char ch = this.queryValuePart.charAt(i);
            if (ch == '?') {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ParameterHolder parameterHolder = parameters[questionMarkPosition++];
                try {
                    parameterHolder.writeTo(baos, 0, Integer.MAX_VALUE);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not write to byte array: " + e.getMessage(), e);
                }
                replacedValuePart.append(baos.toString());
                continue;
            }
            replacedValuePart.append(ch);
        }
        String replaced = replacedValuePart.toString();
        if (this.queryBuilder.length() + replaced.length() + this.onDupKeyPart.length() > 1000000) {
            this.queryBuilder.append(this.onDupKeyPart);
            this.queriesToSend.add(this.queryBuilder.toString());
            this.queryBuilder = new StringBuilder();
            this.queryBuilder.append(this.baseQuery);
            this.firstWritten = false;
        }
        if (this.firstWritten) {
            this.queryBuilder.append(",");
        }
        this.queryBuilder.append(replaced);
        this.firstWritten = true;
        ++this.queryCount;
    }

    public int[] executeBatch() throws QueryException {
        this.queryBuilder.append(this.onDupKeyPart);
        String lastQuery = this.queryBuilder.toString();
        if (this.firstWritten) {
            this.queriesToSend.add(lastQuery);
        }
        for (String query : this.queriesToSend) {
            this.protocol.executeQuery(new DrizzleQuery(query));
        }
        log.finest("Rewrote " + this.queryCount + " queries to " + this.queriesToSend.size() + " queries");
        int[] returnArray = new int[this.queryCount];
        Arrays.fill(returnArray, -2);
        this.queriesToSend.clear();
        this.queryBuilder = new StringBuilder();
        this.queryBuilder.append(this.baseQuery);
        this.firstWritten = false;
        this.queryCount = 0;
        return returnArray;
    }
}

