/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common;

import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SupportedDatabases {
    MYSQL("MySQL"),
    DRIZZLE("Drizzle");

    private final String databaseName;
    private static final Pattern drizzlePattern;

    private SupportedDatabases(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public static SupportedDatabases fromVersionString(String version) {
        if (drizzlePattern.matcher(version).matches()) {
            return DRIZZLE;
        }
        return MYSQL;
    }

    static {
        drizzlePattern = Pattern.compile("^201\\d\\..*");
    }
}

