/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.fontchooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.drjekyll.fontchooser.FontContainer;
import org.drjekyll.fontchooser.listeners.FamilyListSelectionListener;
import org.drjekyll.fontchooser.listeners.SizeListSelectionListener;
import org.drjekyll.fontchooser.listeners.StyleListSelectionListener;
import org.drjekyll.fontchooser.model.DefaultFontSelectionModel;
import org.drjekyll.fontchooser.model.FontSelectionModel;
import org.drjekyll.fontchooser.panes.FamilyPane;
import org.drjekyll.fontchooser.panes.PreviewPane;
import org.drjekyll.fontchooser.panes.SizePane;
import org.drjekyll.fontchooser.panes.StylePane;
import org.drjekyll.fontchooser.util.ResourceBundleUtil;

public class FontChooser
extends JPanel
implements FontContainer {
    private static final int DEFAULT_FONT_SIZE = 12;
    private static final int DEFAULT_SPACE = 11;
    private static final String SELECTION_MODEL_PROPERTY = "selectionModel";
    private FontSelectionModel selectionModel;
    private final ResourceBundle resourceBundle;
    private final ResourceBundleUtil resourceBundleUtil;
    private final JLabel familyLabel = new JLabel();
    private final JLabel styleLabel = new JLabel();
    private final JLabel sizeLabel = new JLabel();
    private final JLabel previewLabel = new JLabel();
    private final JPanel fontPanel = new JPanel();
    private final JPanel previewPanel = new JPanel();
    private final FamilyPane familyPane = new FamilyPane();
    private final PreviewPane previewPane = new PreviewPane();
    private final StylePane stylePane = new StylePane();
    private final SizePane sizePane = new SizePane();
    private final FamilyListSelectionListener familyPaneListener = new FamilyListSelectionListener(this);
    private final StyleListSelectionListener stylePaneListener = new StyleListSelectionListener(this);
    private final SizeListSelectionListener sizePaneListener = new SizeListSelectionListener(this);

    public FontChooser() {
        this(new Font("SansSerif", 0, 12));
    }

    public FontChooser(Font initialFont) {
        this(new DefaultFontSelectionModel(initialFont));
    }

    public FontChooser(FontSelectionModel model) {
        this.resourceBundle = ResourceBundle.getBundle("FontChooser");
        this.resourceBundleUtil = new ResourceBundleUtil(this.resourceBundle);
        this.setSelectionModel(model);
        this.setLayout(new BorderLayout());
        this.addComponents();
        this.initPanes();
        this.previewPane.setPreviewFont(this.selectionModel.getSelectedFont());
    }

    @Override
    public Font getSelectedFont() {
        return this.selectionModel.getSelectedFont();
    }

    @Override
    public void setSelectedFont(Font font) {
        this.familyPane.removeListSelectionListener(this.familyPaneListener);
        this.stylePane.removeListSelectionListener(this.stylePaneListener);
        this.sizePane.removeListSelectionListener(this.sizePaneListener);
        this.selectionModel.setSelectedFont(font);
        this.initPanes();
    }

    public FontSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(FontSelectionModel newModel) {
        if (newModel == null) {
            throw new IllegalArgumentException("New model must not be null");
        }
        FontSelectionModel oldModel = this.selectionModel;
        this.selectionModel = newModel;
        this.selectionModel.addChangeListener(this.stylePane);
        this.firePropertyChange(SELECTION_MODEL_PROPERTY, oldModel, newModel);
    }

    public void addChangeListener(ChangeListener listener) {
        this.selectionModel.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.selectionModel.removeChangeListener(listener);
    }

    private void initPanes() {
        this.familyPane.setSelectedFamily(this.selectionModel.getSelectedFontFamily());
        this.familyPane.addListSelectionListener(this.familyPaneListener);
        this.stylePane.loadFamily(this.selectionModel.getSelectedFontFamily());
        this.stylePane.setSelectedStyle(this.selectionModel.getSelectedFontName());
        this.stylePane.addListSelectionListener(this.stylePaneListener);
        this.sizePane.addListSelectionListener(this.sizePaneListener);
        this.sizePane.setSelectedSize(this.selectionModel.getSelectedFontSize());
    }

    private void addComponents() {
        this.addFontPanel();
        this.addFamilyLabel();
        this.addStyleLabel();
        this.addSizeLabel();
        this.addFamilyPane();
        this.addStylePane();
        this.addSizePane();
        this.addPreviewLabel();
        this.addPreview();
    }

    private void addPreview() {
        this.previewPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.previewPanel.add((Component)this.previewLabel, gridBagConstraints);
        this.add((Component)this.previewPanel, "Last");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        this.previewPanel.add((Component)this.previewPane, gridBagConstraints2);
    }

    private void addPreviewLabel() {
        this.previewLabel.setDisplayedMnemonic(this.resourceBundleUtil.getFirstChar("font.preview.mnemonic"));
        this.previewLabel.setText(this.resourceBundle.getString("font.preview"));
    }

    private void addSizePane() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.fontPanel.add((Component)this.sizePane, gridBagConstraints);
    }

    private void addStylePane() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.fontPanel.add((Component)this.stylePane, gridBagConstraints);
    }

    private void addFamilyPane() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.fontPanel.add((Component)this.familyPane, gridBagConstraints);
    }

    private void addSizeLabel() {
        this.sizeLabel.setLabelFor(this.sizePane);
        this.sizeLabel.setDisplayedMnemonic(this.resourceBundleUtil.getFirstChar("font.size.mnemonic"));
        this.sizeLabel.setText(this.resourceBundle.getString("font.size"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.fontPanel.add((Component)this.sizeLabel, gridBagConstraints);
    }

    private void addStyleLabel() {
        this.styleLabel.setLabelFor(this.stylePane);
        this.styleLabel.setDisplayedMnemonic(this.resourceBundleUtil.getFirstChar("font.style.mnemonic"));
        this.styleLabel.setText(this.resourceBundle.getString("font.style"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 5, 11);
        this.fontPanel.add((Component)this.styleLabel, gridBagConstraints);
    }

    private void addFamilyLabel() {
        this.familyLabel.setLabelFor(this.familyPane);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 5, 11);
        this.fontPanel.add((Component)this.familyLabel, gridBagConstraints);
        this.familyLabel.setDisplayedMnemonic(this.resourceBundleUtil.getFirstChar("font.family.mnemonic"));
        this.familyLabel.setText(this.resourceBundle.getString("font.family"));
    }

    private void addFontPanel() {
        this.fontPanel.setLayout(new GridBagLayout());
        this.add(this.fontPanel);
    }

    @Override
    public String getSelectedStyle() {
        return this.stylePane.getSelectedStyle();
    }

    @Override
    public float getSelectedSize() {
        return this.sizePane.getSelectedSize();
    }

    @Override
    public String getSelectedFamily() {
        return this.familyPane.getSelectedFamily();
    }

    @Override
    public void setPreviewFont(Font font) {
        this.previewPane.setPreviewFont(font);
    }
}

