/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.fontchooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.drjekyll.fontchooser.FontChooser;
import org.drjekyll.fontchooser.util.ResourceBundleUtil;

public class FontDialog
extends JDialog {
    private final FontChooser chooser = new FontChooser();
    private final JButton cancelButton = new JButton();
    private final JButton okButton = new JButton();
    private final ResourceBundle bundle = ResourceBundle.getBundle("FontDialog");
    private final ResourceBundleUtil resourceBundleUtil = new ResourceBundleUtil(this.bundle);
    private boolean cancelSelected;

    public static void showDialog(Component component) {
        FontDialog dialog = new FontDialog((Frame)null, "Select Font", true);
        dialog.setDefaultCloseOperation(2);
        dialog.setSelectedFont(component.getFont());
        dialog.setVisible(true);
        if (!dialog.isCancelSelected()) {
            component.setFont(dialog.getSelectedFont());
        }
    }

    public FontDialog() {
        this.initDialog();
    }

    public FontDialog(Frame owner) {
        super(owner);
        this.initDialog();
    }

    public FontDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.initDialog();
    }

    public FontDialog(Frame owner, String title) {
        super(owner, title);
        this.initDialog();
    }

    public FontDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.initDialog();
    }

    public FontDialog(Frame owner, String title, boolean modal, GraphicsConfiguration gc) {
        super(owner, title, modal, gc);
        this.initDialog();
    }

    public FontDialog(Dialog owner) {
        super(owner);
        this.initDialog();
    }

    public FontDialog(Dialog owner, boolean modal) {
        super(owner, modal);
        this.initDialog();
    }

    public FontDialog(Dialog owner, String title) {
        super(owner, title);
        this.initDialog();
    }

    public FontDialog(Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
        this.initDialog();
    }

    public FontDialog(Dialog owner, String title, boolean modal, GraphicsConfiguration gc) {
        super(owner, title, modal, gc);
        this.initDialog();
    }

    public FontDialog(Window owner) {
        super(owner);
        this.initDialog();
    }

    public FontDialog(Window owner, Dialog.ModalityType modalityType) {
        super(owner, modalityType);
        this.initDialog();
    }

    public FontDialog(Window owner, String title) {
        super(owner, title);
        this.initDialog();
    }

    public FontDialog(Window owner, String title, Dialog.ModalityType modalityType) {
        super(owner, title, modalityType);
        this.initDialog();
    }

    public FontDialog(Window owner, String title, Dialog.ModalityType modalityType, GraphicsConfiguration gc) {
        super(owner, title, modalityType, gc);
        this.initDialog();
    }

    private void initDialog() {
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.addActionListener(event -> {
            this.cancelSelected = true;
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FontDialog.this.cancelSelected = true;
            }
        });
    }

    private void initComponents() {
        JPanel chooserPanel = new JPanel();
        chooserPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
        chooserPanel.setLayout(new BorderLayout(0, 12));
        chooserPanel.add(this.chooser);
        this.add(chooserPanel);
        JPanel controlPanel = new JPanel();
        controlPanel.setBorder(BorderFactory.createEmptyBorder(7, 7, 6, 6));
        controlPanel.setLayout(new FlowLayout(4));
        this.add((Component)controlPanel, "Last");
        this.okButton.setMnemonic(this.resourceBundleUtil.getFirstChar("action.ok.mnemonic"));
        this.okButton.setText(this.bundle.getString("action.ok"));
        this.okButton.addActionListener(event -> this.dispose());
        controlPanel.add(this.okButton);
        this.cancelButton.setMnemonic(this.resourceBundleUtil.getFirstChar("action.cancel.mnemonic"));
        this.cancelButton.setText(this.bundle.getString("action.cancel"));
        this.cancelButton.addActionListener(event -> {
            this.cancelSelected = true;
            this.dispose();
        });
        controlPanel.add(this.cancelButton);
        this.pack();
    }

    public Font getSelectedFont() {
        return this.chooser.getSelectedFont();
    }

    public void setSelectedFont(Font font) {
        this.chooser.setSelectedFont(font);
    }

    public boolean isCancelSelected() {
        return this.cancelSelected;
    }
}

