/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.fontchooser.panes;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JFormattedTextField;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionListener;

public class SizePane
extends JPanel {
    private final JList<Integer> sizeList = new JList();
    private final JSpinner sizeSpinner = new JSpinner();
    private final DefaultListModel<Integer> sizeListModel = new DefaultListModel();

    public SizePane() {
        this.setLayout(new GridBagLayout());
        this.initSizeListModel();
        this.initSizeList();
        this.initSizeSpinner();
        this.addSizeSpinner();
        this.addSizeScrollPane();
    }

    private void addSizeScrollPane() {
        JScrollPane sizeScrollPane = new JScrollPane();
        sizeScrollPane.setMinimumSize(new Dimension(50, 50));
        sizeScrollPane.setPreferredSize(new Dimension(60, 100));
        sizeScrollPane.setViewportView(this.sizeList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)sizeScrollPane, gridBagConstraints);
    }

    private void addSizeSpinner() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.sizeSpinner, gridBagConstraints);
    }

    private void initSizeSpinner() {
        int spinnerHeight = (int)this.sizeSpinner.getPreferredSize().getHeight();
        this.sizeSpinner.setPreferredSize(new Dimension(60, spinnerHeight));
        this.sizeSpinner.setModel(new SpinnerNumberModel(12, 6, 128, 1));
        JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)this.sizeSpinner.getEditor();
        JFormattedTextField textField = editor.getTextField();
        textField.setBorder(new JScrollPane().getBorder());
        this.sizeSpinner.addChangeListener(event -> {
            Integer value = (Integer)this.sizeSpinner.getValue();
            int index = ((DefaultListModel)this.sizeList.getModel()).indexOf(value);
            if (index > -1) {
                this.sizeList.setSelectedValue(value, true);
            } else {
                this.sizeList.clearSelection();
            }
        });
    }

    private void initSizeList() {
        this.sizeList.setModel(this.sizeListModel);
        this.sizeList.getSelectionModel().setSelectionMode(0);
        this.sizeList.addListSelectionListener(event -> {
            int index;
            if (!event.getValueIsAdjusting() && (index = ((DefaultListModel)this.sizeList.getModel()).indexOf(this.sizeList.getSelectedValue())) > -1) {
                this.sizeSpinner.setValue(this.sizeList.getSelectedValue());
            }
        });
        DefaultListCellRenderer renderer = (DefaultListCellRenderer)this.sizeList.getCellRenderer();
        renderer.setHorizontalAlignment(4);
    }

    private void initSizeListModel() {
        int size = 6;
        int step = 1;
        int ceil = 14;
        do {
            this.sizeListModel.addElement(size);
            if (size != ceil) continue;
            ceil += ceil;
            step += step;
        } while ((size += step) <= 128);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.sizeList.addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.sizeList.removeListSelectionListener(listener);
    }

    public void setSelectedSize(int size) {
        if (this.sizeListModel.contains(size)) {
            this.sizeList.setSelectedValue(size, true);
        }
        this.sizeSpinner.setValue(size);
    }

    public int getSelectedSize() {
        if (!this.sizeList.isSelectionEmpty()) {
            return this.sizeList.getSelectedValue();
        }
        return (Integer)this.sizeSpinner.getValue();
    }
}

