/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.fontchooser.panes;

import java.awt.Dimension;
import java.awt.Font;
import java.util.Objects;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionListener;
import org.drjekyll.fontchooser.FontFamilies;
import org.drjekyll.fontchooser.FontFamily;
import org.drjekyll.fontchooser.model.FontSelectionModel;
import org.drjekyll.fontchooser.panes.ToolTipCellRenderer;

public class StylePane
extends JScrollPane
implements ChangeListener {
    private final JList<String> styleList = new JList();
    private final DefaultListModel<String> styleListModel = new DefaultListModel();
    private String family;

    public StylePane() {
        this.styleList.setModel(this.styleListModel);
        this.styleList.getSelectionModel().setSelectionMode(0);
        this.styleList.setCellRenderer(new ToolTipCellRenderer());
        this.setMinimumSize(new Dimension(140, 50));
        this.setPreferredSize(new Dimension(160, 100));
        this.setViewportView(this.styleList);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.styleList.addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.styleList.removeListSelectionListener(listener);
    }

    public void setSelectedStyle(String name) {
        this.styleList.setSelectedValue(name, true);
    }

    public String getSelectedStyle() {
        return this.styleList.getSelectedValue();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        FontSelectionModel fontSelectionModel = (FontSelectionModel)e.getSource();
        Font selectedFont = fontSelectionModel.getSelectedFont();
        String family = selectedFont.getFamily();
        this.loadFamily(family);
    }

    public void loadFamily(String family) {
        if (Objects.equals(this.family, family)) {
            return;
        }
        this.family = family;
        FontFamilies fontFamilies = FontFamilies.getInstance();
        FontFamily fontFamily = fontFamilies.get(family);
        if (fontFamily != null) {
            ListSelectionListener[] selectionListeners = this.styleList.getListSelectionListeners();
            this.removeSelectionListeners(selectionListeners);
            this.updateListModel(fontFamily);
            this.addSelectionListeners(selectionListeners);
        }
    }

    private void updateListModel(Iterable<Font> fonts) {
        this.styleListModel.clear();
        for (Font font : fonts) {
            this.styleListModel.addElement(font.getName());
        }
    }

    private void addSelectionListeners(ListSelectionListener[] selectionListeners) {
        for (ListSelectionListener listener : selectionListeners) {
            this.styleList.addListSelectionListener(listener);
        }
    }

    private void removeSelectionListeners(ListSelectionListener[] selectionListeners) {
        for (ListSelectionListener listener : selectionListeners) {
            this.styleList.removeListSelectionListener(listener);
        }
    }
}

