/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.adapter.common;

import com.google.common.eventbus.Subscribe;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.dromara.dynamictp.adapter.common.DtpAdapter;
import org.dromara.dynamictp.common.constant.DynamicTpConst;
import org.dromara.dynamictp.common.event.AlarmCheckEvent;
import org.dromara.dynamictp.common.event.CollectEvent;
import org.dromara.dynamictp.common.event.RefreshEvent;
import org.dromara.dynamictp.common.manager.ContextManagerHelper;
import org.dromara.dynamictp.common.manager.EventBusManager;
import org.dromara.dynamictp.common.properties.DtpProperties;
import org.dromara.dynamictp.core.handler.CollectorHandler;
import org.dromara.dynamictp.core.notifier.manager.AlarmManager;
import org.dromara.dynamictp.core.support.ExecutorWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtpAdapterListener {
    private static final Logger log = LoggerFactory.getLogger(DtpAdapterListener.class);

    public DtpAdapterListener() {
        EventBusManager.register((Object)this);
    }

    @Subscribe
    public void handleDtpEvent(EventObject event) {
        try {
            if (event instanceof RefreshEvent) {
                RefreshEvent refreshEvent = (RefreshEvent)event;
                this.doRefresh(refreshEvent.getDtpProperties());
            } else if (event instanceof CollectEvent) {
                CollectEvent collectEvent = (CollectEvent)event;
                this.doCollect(collectEvent.getDtpProperties());
            } else if (event instanceof AlarmCheckEvent) {
                AlarmCheckEvent alarmCheckEvent = (AlarmCheckEvent)event;
                this.doAlarmCheck(alarmCheckEvent.getDtpProperties());
            }
        }
        catch (Exception e) {
            log.error("DynamicTp adapter, event handle failed.", (Throwable)e);
        }
    }

    protected void doCollect(DtpProperties dtpProperties) {
        Map handlerMap = ContextManagerHelper.getBeansOfType(DtpAdapter.class);
        if (MapUtils.isEmpty((Map)handlerMap)) {
            return;
        }
        handlerMap.forEach((k, v) -> v.getMultiPoolStats().forEach(ps -> CollectorHandler.getInstance().collect(ps, dtpProperties.getCollectorTypes())));
    }

    protected void doRefresh(DtpProperties dtpProperties) {
        Map handlerMap = ContextManagerHelper.getBeansOfType(DtpAdapter.class);
        if (MapUtils.isEmpty((Map)handlerMap)) {
            return;
        }
        handlerMap.forEach((k, v) -> v.refresh(dtpProperties));
    }

    protected void doAlarmCheck(DtpProperties dtpProperties) {
        Map handlerMap = ContextManagerHelper.getBeansOfType(DtpAdapter.class);
        if (MapUtils.isEmpty((Map)handlerMap)) {
            return;
        }
        handlerMap.forEach((k, v) -> {
            Map<String, ExecutorWrapper> executorWrapper = v.getExecutorWrappers();
            executorWrapper.forEach((kk, vv) -> AlarmManager.tryAlarmAsync((ExecutorWrapper)vv, (List)DynamicTpConst.SCHEDULE_NOTIFY_ITEMS));
        });
    }
}

