/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.adapter.dubbo.alibaba;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.common.store.DataStore;
import com.alibaba.dubbo.remoting.transport.dispatcher.WrappedChannelHandler;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.dromara.dynamictp.adapter.common.AbstractDtpAdapter;
import org.dromara.dynamictp.common.event.CustomContextRefreshedEvent;
import org.dromara.dynamictp.common.manager.ContextManagerHelper;
import org.dromara.dynamictp.common.properties.DtpProperties;
import org.dromara.dynamictp.jvmti.JVMTI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class AlibabaDubboDtpAdapter
extends AbstractDtpAdapter
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlibabaDubboDtpAdapter.class);
    private static final String TP_PREFIX = "dubboTp";
    private static final String EXECUTOR_FIELD = "executor";
    private final AtomicBoolean registered = new AtomicBoolean(false);

    @Subscribe
    public synchronized void onContextRefreshedEvent(CustomContextRefreshedEvent event) {
    }

    public void afterPropertiesSet() throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(() -> {
            while (!this.registered.get()) {
                try {
                    Thread.sleep(1000L);
                    DtpProperties dtpProperties = (DtpProperties)ContextManagerHelper.getBean(DtpProperties.class);
                    this.initialize();
                    this.afterInitialize();
                    this.refresh(dtpProperties);
                    log.info("DynamicTp adapter, {} init end, executors {}", (Object)this.getTpPrefix(), this.executors.keySet());
                }
                catch (Throwable throwable) {}
            }
        });
        executor.shutdown();
    }

    public void refresh(DtpProperties dtpProperties) {
        this.refresh(dtpProperties.getDubboTp(), dtpProperties.getPlatforms());
    }

    protected void initialize() {
        super.initialize();
        List handlers = JVMTI.getInstances(WrappedChannelHandler.class);
        if (CollectionUtils.isNotEmpty((Collection)handlers) && this.registered.compareAndSet(false, true)) {
            DataStore dataStore = (DataStore)ExtensionLoader.getExtensionLoader(DataStore.class).getDefaultExtension();
            handlers.forEach(handler -> {
                ExecutorService executor = handler.getExecutor();
                if (executor instanceof ThreadPoolExecutor) {
                    String port = String.valueOf(handler.getUrl().getPort());
                    String tpName = this.genTpName(port);
                    this.enhanceOriginExecutor(tpName, (ThreadPoolExecutor)executor, EXECUTOR_FIELD, handler);
                    dataStore.put(Constants.EXECUTOR_SERVICE_COMPONENT_KEY, port, (Object)handler.getExecutor());
                }
            });
        }
    }

    protected String getTpPrefix() {
        return TP_PREFIX;
    }

    private String genTpName(String port) {
        return "dubboTp#" + port;
    }
}

