/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.adapter.dubbo.apache;

import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.store.DataStore;
import org.apache.dubbo.common.threadpool.manager.DefaultExecutorRepository;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.threadpool.support.eager.EagerThreadPoolExecutor;
import org.apache.dubbo.config.spring.context.event.ServiceBeanExportedEvent;
import org.apache.dubbo.remoting.transport.dispatcher.WrappedChannelHandler;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.dromara.dynamictp.adapter.common.AbstractDtpAdapter;
import org.dromara.dynamictp.adapter.dubbo.apache.DubboVersion;
import org.dromara.dynamictp.adapter.dubbo.apache.EagerThreadPoolExecutorProxy;
import org.dromara.dynamictp.common.event.CustomContextRefreshedEvent;
import org.dromara.dynamictp.common.manager.ContextManagerHelper;
import org.dromara.dynamictp.common.properties.DtpProperties;
import org.dromara.dynamictp.common.util.ReflectionUtil;
import org.dromara.dynamictp.core.support.proxy.ThreadPoolExecutorProxy;
import org.dromara.dynamictp.jvmti.JVMTI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class ApacheDubboDtpAdapter
extends AbstractDtpAdapter
implements ApplicationListener<ApplicationEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApacheDubboDtpAdapter.class);
    private static final String TP_PREFIX = "dubboTp";
    private static final String EXECUTOR_SERVICE_COMPONENT_KEY = ExecutorService.class.getName();
    private static final String INTERNAL_EXECUTOR_SERVICE_COMPONENT_KEY = "INTERNAL_SERVICE_EXECUTOR";
    private static final String EXECUTOR_FIELD = "executor";

    @Subscribe
    public synchronized void onContextRefreshedEvent(CustomContextRefreshedEvent event) {
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ServiceBeanExportedEvent) {
            try {
                DtpProperties dtpProperties = (DtpProperties)ContextManagerHelper.getBean(DtpProperties.class);
                this.initialize();
                this.afterInitialize();
                this.refresh(dtpProperties);
                log.info("DynamicTp adapter, {} init end, executors {}", (Object)this.getTpPrefix(), this.executors.keySet());
            }
            catch (Exception e) {
                log.error("DynamicTp adapter, {} init failed.", (Object)this.getTpPrefix(), (Object)e);
            }
        }
    }

    public void refresh(DtpProperties dtpProperties) {
        this.refresh(dtpProperties.getDubboTp(), dtpProperties.getPlatforms());
    }

    protected String getTpPrefix() {
        return TP_PREFIX;
    }

    protected void initialize() {
        Map executorMap;
        super.initialize();
        String currVersion = Version.getVersion();
        if (DubboVersion.compare("2.7.5", currVersion) > 0) {
            this.handleLessThanV275();
            return;
        }
        ExecutorRepository executorRepository = DubboVersion.compare(currVersion, "3.0.3") >= 0 ? (ExecutorRepository)ApplicationModel.defaultModel().getExtensionLoader(ExecutorRepository.class).getDefaultExtension() : (ExecutorRepository)ExtensionLoader.getExtensionLoader(ExecutorRepository.class).getDefaultExtension();
        ConcurrentMap data = (ConcurrentMap)ReflectionUtil.getFieldValue(DefaultExecutorRepository.class, (String)"data", (Object)executorRepository);
        if (Objects.isNull(data)) {
            return;
        }
        boolean useInternalExecutorVersion = DubboVersion.compare(currVersion, "3.0.9") >= 0 && DubboVersion.compare(currVersion, "3.1.8") < 0;
        Map map = executorMap = useInternalExecutorVersion ? (Map)data.get(INTERNAL_EXECUTOR_SERVICE_COMPONENT_KEY) : (Map)data.get(EXECUTOR_SERVICE_COMPONENT_KEY);
        if (MapUtils.isNotEmpty((Map)executorMap)) {
            executorMap.forEach((k, v) -> {
                ThreadPoolExecutor proxy = this.getProxy((Executor)v);
                executorMap.replace(k, proxy);
                this.putAndFinalize(this.genTpName(k.toString()), (ExecutorService)v, proxy);
            });
        }
    }

    private void handleLessThanV275() {
        List handlers = JVMTI.getInstances(WrappedChannelHandler.class);
        if (CollectionUtils.isEmpty((Collection)handlers)) {
            return;
        }
        DataStore dataStore = (DataStore)ExtensionLoader.getExtensionLoader(DataStore.class).getDefaultExtension();
        handlers.forEach(handler -> {
            Object originExecutor = ReflectionUtil.getFieldValue((String)EXECUTOR_FIELD, (Object)handler);
            if (!(originExecutor instanceof ExecutorService)) {
                return;
            }
            URL url = handler.getUrl();
            if (!"consumer".equalsIgnoreCase(url.getParameter("side"))) {
                String port = String.valueOf(url.getPort());
                String tpName = this.genTpName(port);
                this.enhanceOriginExecutor(tpName, (ThreadPoolExecutor)originExecutor, EXECUTOR_FIELD, handler);
                Object newExexutor = ReflectionUtil.getFieldValue((String)EXECUTOR_FIELD, (Object)handler);
                dataStore.put(EXECUTOR_SERVICE_COMPONENT_KEY, port, newExexutor);
            }
        });
    }

    private ThreadPoolExecutor getProxy(Executor executor) {
        EagerThreadPoolExecutorProxy proxy = executor instanceof EagerThreadPoolExecutor ? new EagerThreadPoolExecutorProxy((EagerThreadPoolExecutor)executor) : new ThreadPoolExecutorProxy((ThreadPoolExecutor)executor);
        return proxy;
    }

    private String genTpName(String port) {
        return "dubboTp#" + port;
    }
}

