/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.adapter.dubbo.apache;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.threadpool.support.eager.EagerThreadPoolExecutor;
import org.apache.dubbo.common.threadpool.support.eager.TaskQueue;
import org.dromara.dynamictp.common.util.ExecutorUtil;
import org.dromara.dynamictp.core.aware.AwareManager;
import org.dromara.dynamictp.core.aware.RejectHandlerAware;
import org.dromara.dynamictp.core.aware.TaskEnhanceAware;
import org.dromara.dynamictp.core.reject.RejectHandlerGetter;
import org.dromara.dynamictp.core.support.task.wrapper.TaskWrapper;

public class EagerThreadPoolExecutorProxy
extends EagerThreadPoolExecutor
implements TaskEnhanceAware,
RejectHandlerAware {
    private List<TaskWrapper> taskWrappers;
    private String rejectHandlerType;

    public EagerThreadPoolExecutorProxy(EagerThreadPoolExecutor executor) {
        super(executor.getCorePoolSize(), executor.getMaximumPoolSize(), executor.getKeepAliveTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, (TaskQueue)executor.getQueue(), executor.getThreadFactory(), executor.getRejectedExecutionHandler());
        this.allowCoreThreadTimeOut(executor.allowsCoreThreadTimeOut());
        this.rejectHandlerType = this.getRejectedExecutionHandler().getClass().getSimpleName();
        this.setRejectedExecutionHandler(RejectHandlerGetter.getProxy((RejectedExecutionHandler)this.getRejectedExecutionHandler()));
        ((TaskQueue)this.getQueue()).setExecutor((EagerThreadPoolExecutor)this);
    }

    public void execute(Runnable command) {
        command = this.getEnhancedTask(command);
        AwareManager.execute((Executor)((Object)this), (Runnable)command);
        super.execute(command);
    }

    protected void beforeExecute(Thread t, Runnable r) {
        AwareManager.beforeExecute((Executor)((Object)this), (Thread)t, (Runnable)r);
        super.beforeExecute(t, r);
    }

    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        AwareManager.afterExecute((Executor)((Object)this), (Runnable)r, (Throwable)t);
        ExecutorUtil.tryExecAfterExecute((Runnable)r, (Throwable)t);
    }

    public List<TaskWrapper> getTaskWrappers() {
        return this.taskWrappers;
    }

    public void setTaskWrappers(List<TaskWrapper> taskWrappers) {
        this.taskWrappers = taskWrappers;
    }

    public String getRejectHandlerType() {
        return this.rejectHandlerType;
    }

    public void setRejectHandlerType(String rejectHandlerType) {
        this.rejectHandlerType = rejectHandlerType;
    }
}

