/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.adapter.rocketmq;

import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.impl.rocketmq.ConsumerImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.DefaultMQPushConsumer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.ConsumeMessageConcurrentlyService;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.ConsumeMessageOrderlyService;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.ConsumeMessageService;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.DefaultMQPushConsumerImpl;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.dromara.dynamictp.adapter.common.AbstractDtpAdapter;
import org.dromara.dynamictp.common.manager.ContextManagerHelper;
import org.dromara.dynamictp.common.properties.DtpProperties;
import org.dromara.dynamictp.common.util.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunOnsRocketMqAdapter
extends AbstractDtpAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AliyunOnsRocketMqAdapter.class);
    private static final String TP_PREFIX = "rocketMqTp";
    private static final String CONSUME_EXECUTOR_FIELD = "consumeExecutor";

    public void refresh(DtpProperties dtpProperties) {
        this.refresh(dtpProperties.getRocketMqTp(), dtpProperties.getPlatforms());
    }

    protected String getTpPrefix() {
        return TP_PREFIX;
    }

    protected void initialize() {
        super.initialize();
        this.adaptConsumerExecutors();
    }

    private void adaptConsumerExecutors() {
        Map beans = ContextManagerHelper.getBeansOfType(Consumer.class);
        if (MapUtils.isEmpty((Map)beans)) {
            log.warn("Cannot find beans of type Consumer.");
            return;
        }
        beans.forEach(this::accept);
    }

    private void accept(String k, Consumer v) {
        ConsumerImpl consumer = (ConsumerImpl)v;
        DefaultMQPushConsumer defaultMqPushConsumer = (DefaultMQPushConsumer)ReflectionUtil.getFieldValue(ConsumerImpl.class, (String)"defaultMQPushConsumer", (Object)consumer);
        if (Objects.isNull(defaultMqPushConsumer)) {
            return;
        }
        DefaultMQPushConsumerImpl impl = (DefaultMQPushConsumerImpl)ReflectionUtil.getFieldValue(DefaultMQPushConsumer.class, (String)"defaultMQPushConsumerImpl", (Object)defaultMqPushConsumer);
        if (Objects.isNull(impl)) {
            return;
        }
        ConsumeMessageService consumeMessageService = impl.getConsumeMessageService();
        Object tpName = defaultMqPushConsumer.getConsumerGroup();
        if (consumeMessageService instanceof ConsumeMessageConcurrentlyService) {
            tpName = "rocketMqTp#consumer#concurrently#" + (String)tpName;
        } else if (consumeMessageService instanceof ConsumeMessageOrderlyService) {
            tpName = "rocketMqTp#consumer#orderly#" + (String)tpName;
        }
        ThreadPoolExecutor executor = (ThreadPoolExecutor)ReflectionUtil.getFieldValue((String)CONSUME_EXECUTOR_FIELD, (Object)consumeMessageService);
        if (Objects.nonNull(executor)) {
            this.enhanceOriginExecutor((String)tpName, executor, CONSUME_EXECUTOR_FIELD, consumeMessageService);
        }
    }
}

