/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.common.notifier;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Objects;
import lombok.Generated;
import org.dromara.dynamictp.common.entity.NotifyPlatform;
import org.dromara.dynamictp.common.notifier.AbstractNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpNotifier
extends AbstractNotifier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractHttpNotifier.class);

    @Override
    protected void send0(NotifyPlatform platform, String content) {
        HttpResponse response;
        String url = this.buildUrl(platform);
        String msgBody = this.buildMsgBody(platform, content);
        HttpRequest request = HttpRequest.post((String)url).setConnectionTimeout(platform.getTimeout().intValue()).setReadTimeout(platform.getTimeout().intValue()).body(msgBody);
        if (platform.getProxyType() != Proxy.Type.DIRECT) {
            request.setProxy(new Proxy(platform.getProxyType(), new InetSocketAddress(platform.getProxyHost(), platform.getProxyPort())));
        }
        if (Objects.nonNull(response = request.execute())) {
            log.info("DynamicTp notify, {} send success, response: {}, request: {}", new Object[]{this.platform(), response.body(), msgBody});
        }
    }

    protected abstract String buildMsgBody(NotifyPlatform var1, String var2);

    protected abstract String buildUrl(NotifyPlatform var1);
}

