/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.common.parser.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.dromara.dynamictp.common.parser.json.AbstractJsonParser;

public class GsonParser
extends AbstractJsonParser {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String PACKAGE_NAME = "com.google.gson.Gson";
    private volatile Gson mapper;

    @Override
    public <T> T fromJson(String json, Type typeOfT) {
        return (T)this.getMapper().fromJson(json, typeOfT);
    }

    @Override
    public String toJson(Object obj) {
        return this.getMapper().toJson(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Gson getMapper() {
        if (this.mapper == null) {
            GsonParser gsonParser = this;
            synchronized (gsonParser) {
                if (this.mapper == null) {
                    this.mapper = this.createMapper();
                }
            }
        }
        return this.mapper;
    }

    protected Gson createMapper() {
        TypeAdapter<LocalDateTime> timeTypeAdapter = new TypeAdapter<LocalDateTime>(){

            public void write(JsonWriter out, LocalDateTime value) throws IOException {
                if (Objects.nonNull(value)) {
                    out.value(value.format(DateTimeFormatter.ofPattern(GsonParser.DATE_FORMAT)));
                } else {
                    out.nullValue();
                }
            }

            public LocalDateTime read(JsonReader in) throws IOException {
                JsonToken token = in.peek();
                if (token == JsonToken.NULL) {
                    return null;
                }
                return LocalDateTime.parse(in.nextString(), DateTimeFormatter.ofPattern(GsonParser.DATE_FORMAT));
            }
        };
        return new GsonBuilder().setDateFormat(DATE_FORMAT).registerTypeAdapter(LocalDateTime.class, (Object)timeTypeAdapter).create();
    }

    @Override
    protected String[] getMapperClassNames() {
        return new String[]{PACKAGE_NAME};
    }
}

