/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.common.plugin;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dromara.dynamictp.common.plugin.DtpInterceptor;
import org.dromara.dynamictp.common.plugin.DtpIntercepts;
import org.dromara.dynamictp.common.util.ExtensionServiceLoader;
import org.dromara.dynamictp.common.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtpInterceptorRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DtpInterceptorRegistry.class);
    private static final Map<String, DtpInterceptor> INTERCEPTORS = Maps.newConcurrentMap();

    private DtpInterceptorRegistry() {
    }

    public static void register(String name, DtpInterceptor dtpInterceptor) {
        log.info("DynamicTp register DtpInterceptor, name: {}, interceptor: {}", (Object)name, (Object)dtpInterceptor);
        INTERCEPTORS.put(name, dtpInterceptor);
    }

    public static Map<String, DtpInterceptor> getInterceptors() {
        return Collections.unmodifiableMap(INTERCEPTORS);
    }

    public static Object pluginAll(Object target) {
        return DtpInterceptorRegistry.plugin(target, INTERCEPTORS.keySet());
    }

    public static Object pluginAll(Object target, Class<?>[] argTypes, Object[] args) {
        return DtpInterceptorRegistry.plugin(target, INTERCEPTORS.keySet(), argTypes, args);
    }

    public static Object plugin(Object target, Set<String> interceptors) {
        Collection<DtpInterceptor> filterInterceptors = DtpInterceptorRegistry.getInterceptors(interceptors);
        for (DtpInterceptor interceptor : filterInterceptors) {
            target = interceptor.plugin(target);
        }
        return target;
    }

    public static Object plugin(Object target, Set<String> interceptors, Class<?>[] argTypes, Object[] args) {
        Collection<DtpInterceptor> filterInterceptors = DtpInterceptorRegistry.getInterceptors(interceptors);
        for (DtpInterceptor interceptor : filterInterceptors) {
            target = interceptor.plugin(target, argTypes, args);
        }
        return target;
    }

    private static Collection<DtpInterceptor> getInterceptors(Set<String> interceptors) {
        if (CollectionUtils.isEmpty(interceptors)) {
            return INTERCEPTORS.values();
        }
        return INTERCEPTORS.entrySet().stream().filter(x -> StringUtil.containsIgnoreCase((CharSequence)x.getKey(), interceptors)).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    static {
        List<DtpInterceptor> loadedInterceptors = ExtensionServiceLoader.get(DtpInterceptor.class);
        if (CollectionUtils.isNotEmpty(loadedInterceptors)) {
            loadedInterceptors.forEach(x -> {
                DtpIntercepts interceptsAnno = x.getClass().getAnnotation(DtpIntercepts.class);
                if (Objects.nonNull(interceptsAnno)) {
                    String name = StringUtils.isBlank((CharSequence)interceptsAnno.name()) ? x.getClass().getSimpleName() : interceptsAnno.name();
                    INTERCEPTORS.put(name, (DtpInterceptor)x);
                }
            });
        }
    }
}

