/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectionUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReflectionUtil.class);

    private ReflectionUtil() {
    }

    public static Object getFieldValue(String fieldName, Object targetObj) {
        Field field = ReflectionUtil.getField(targetObj.getClass(), fieldName);
        if (Objects.isNull(field)) {
            return null;
        }
        try {
            return FieldUtils.readField((Field)field, (Object)targetObj, (boolean)true);
        }
        catch (IllegalAccessException e) {
            log.error("Failed to read field '{}' from object '{}'", new Object[]{fieldName, targetObj, e});
            return null;
        }
    }

    public static Object getFieldValue(Class<?> targetClass, String fieldName, Object targetObj) {
        Field field = ReflectionUtil.getField(targetClass, fieldName);
        if (Objects.isNull(field)) {
            return null;
        }
        try {
            return FieldUtils.readField((Field)field, (Object)targetObj, (boolean)true);
        }
        catch (IllegalAccessException e) {
            log.error("Failed to read field '{}' from object '{}'", new Object[]{fieldName, targetObj, e});
            return null;
        }
    }

    public static boolean setFieldValue(String fieldName, Object targetObj, Object targetVal) {
        return ReflectionUtil.setFieldValue(targetObj.getClass(), fieldName, targetObj, targetVal);
    }

    public static boolean setFieldValue(Class<?> targetClass, String fieldName, Object targetObj, Object targetVal) {
        Field field = ReflectionUtil.getField(targetClass, fieldName);
        if (Objects.isNull(field)) {
            return false;
        }
        try {
            FieldUtils.writeField((Field)field, (Object)targetObj, (Object)targetVal, (boolean)true);
            return true;
        }
        catch (IllegalAccessException e) {
            log.error("Failed to write value '{}' to field '{}' in object '{}'", new Object[]{targetVal, fieldName, targetObj, e});
            return false;
        }
    }

    public static boolean setFieldValue(Field field, Object targetObj, Object targetVal) {
        try {
            FieldUtils.writeField((Field)field, (Object)targetObj, (Object)targetVal, (boolean)true);
            return true;
        }
        catch (IllegalAccessException e) {
            log.error("Failed to write value '{}' to field '{}' in object '{}'", new Object[]{targetVal, field.getName(), targetObj, e});
            return false;
        }
    }

    public static Field getField(Class<?> targetClass, String fieldName) {
        Field field = FieldUtils.getField(targetClass, (String)fieldName, (boolean)true);
        if (Objects.isNull(field)) {
            log.warn("Field '{}' not found in class '{}'", (Object)fieldName, (Object)targetClass.getName());
            return null;
        }
        return field;
    }

    public static Method findMethod(Class<?> targetClass, String methodName, Class<?> ... parameterTypes) {
        Method method = MethodUtils.getMatchingMethod(targetClass, (String)methodName, (Class[])parameterTypes);
        if (Objects.isNull(method)) {
            log.warn("Method '{}' with parameters '{}' not found in class '{}'", new Object[]{methodName, parameterTypes, targetClass.getName()});
            return null;
        }
        return method;
    }

    public static List<Field> getAllFields(Class<?> targetClass) {
        return FieldUtils.getAllFieldsList(targetClass);
    }
}

