/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.jvmti;

import java.io.File;
import org.dromara.dynamictp.jvmti.JVMTIUtils;
import org.scijava.nativelib.JniExtractor;
import org.scijava.nativelib.NativeLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JVMTI {
    private static final Logger log = LoggerFactory.getLogger(JVMTI.class);
    private static final String LIB_NAME = "JniLibrary";

    public static <T> T getInstance(Class<T> klass) {
        T[] instances = JVMTI.getInstances0(klass, 1);
        if (null == instances || instances.length == 0) {
            return null;
        }
        if (instances.length > 1) {
            throw new RuntimeException("expect only one instance, actually find many instances !");
        }
        return instances[0];
    }

    public static <T> T[] getInstances(Class<T> klass) {
        return JVMTI.getInstances0(klass, -1);
    }

    public static <T> T[] getInstances(Class<T> klass, int limit) {
        return JVMTI.getInstances0(klass, limit);
    }

    private static synchronized native <T> T[] getInstances0(Class<T> var0, int var1);

    public static synchronized native void forceGc();

    static {
        try {
            JniExtractor extractor = NativeLoader.getJniExtractor();
            String path = extractor.extractJni("", LIB_NAME).getAbsolutePath();
            System.load(path);
        }
        catch (Throwable ignored) {
            try {
                File path = new File(JVMTI.class.getProtectionDomain().getCodeSource().getLocation().getPath());
                String libPath = new File(path, JVMTIUtils.detectLibName()).getAbsolutePath();
                System.load(libPath);
            }
            catch (Throwable t) {
                log.error("JVMTI init failed !", t);
            }
        }
    }
}

