/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.starter.adapter.webserver.undertow;

import io.undertow.Undertow;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.dromara.dynamictp.common.properties.DtpProperties;
import org.dromara.dynamictp.common.util.ReflectionUtil;
import org.dromara.dynamictp.core.support.ExecutorWrapper;
import org.dromara.dynamictp.starter.adapter.webserver.AbstractWebServerDtpAdapter;
import org.dromara.dynamictp.starter.adapter.webserver.undertow.EnhancedQueueExecutorProxy;
import org.dromara.dynamictp.starter.adapter.webserver.undertow.TaskPoolHandlerFactory;
import org.dromara.dynamictp.starter.adapter.webserver.undertow.taskpool.EnhancedQueueExecutorTaskPoolAdapter;
import org.dromara.dynamictp.starter.adapter.webserver.undertow.taskpool.TaskPoolAdapter;
import org.jboss.threads.EnhancedQueueExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServer;
import org.springframework.boot.web.server.WebServer;
import org.xnio.XnioWorker;

public class UndertowDtpAdapter
extends AbstractWebServerDtpAdapter<XnioWorker> {
    private static final Logger log = LoggerFactory.getLogger(UndertowDtpAdapter.class);
    private static final String TP_PREFIX = "undertowTp";

    public UndertowDtpAdapter() {
        System.setProperty("jboss.threads.eqe.statistics.active-count", "true");
        System.setProperty("jboss.threads.eqe.statistics", "true");
    }

    @Override
    public void doEnhance(WebServer webServer) {
        UndertowServletWebServer undertowServletWebServer = (UndertowServletWebServer)webServer;
        Undertow undertow = (Undertow)ReflectionUtil.getFieldValue(UndertowServletWebServer.class, (String)"undertow", (Object)undertowServletWebServer);
        if (Objects.isNull(undertow)) {
            return;
        }
        XnioWorker xnioWorker = undertow.getWorker();
        Object taskPool = ReflectionUtil.getFieldValue(XnioWorker.class, (String)"taskPool", (Object)xnioWorker);
        if (Objects.isNull(taskPool)) {
            return;
        }
        TaskPoolAdapter handler = TaskPoolHandlerFactory.getTaskPoolHandler(taskPool.getClass().getSimpleName());
        String internalExecutor = handler.taskPoolType().getInternalExecutor();
        Object executor = ReflectionUtil.getFieldValue(taskPool.getClass(), (String)internalExecutor, (Object)taskPool);
        String tpName = this.getTpName();
        if (executor instanceof ThreadPoolExecutor) {
            this.enhanceOriginExecutor(tpName, (ThreadPoolExecutor)executor, internalExecutor, taskPool);
        } else if (executor instanceof EnhancedQueueExecutor) {
            try {
                EnhancedQueueExecutorProxy proxy = new EnhancedQueueExecutorProxy((EnhancedQueueExecutor)((Object)executor));
                ReflectionUtil.setFieldValue((String)internalExecutor, (Object)taskPool, (Object)((Object)proxy));
                this.putAndFinalize(tpName, (ExecutorService)executor, (Executor)((Object)new EnhancedQueueExecutorTaskPoolAdapter.EnhancedQueueExecutorAdapter(proxy)));
            }
            catch (Throwable t) {
                log.error("DynamicTp adapter, enhance {} failed, please adjust the order of the two dependencies(spring-boot-starter-undertow and starter-adapter-webserver) and try again.", (Object)tpName, (Object)t);
                this.executors.put(tpName, new ExecutorWrapper(tpName, handler.adapt(executor)));
            }
        } else {
            this.executors.put(tpName, new ExecutorWrapper(tpName, handler.adapt(executor)));
        }
    }

    public void refresh(DtpProperties dtpProperties) {
        this.refresh((ExecutorWrapper)this.executors.get(this.getTpName()), dtpProperties.getPlatforms(), dtpProperties.getUndertowTp());
    }

    protected String getTpPrefix() {
        return TP_PREFIX;
    }
}

