/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.starter.common.monitor;

import cn.hutool.core.io.FileUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.dromara.dynamictp.common.entity.JvmStats;
import org.dromara.dynamictp.common.entity.Metrics;
import org.dromara.dynamictp.common.manager.ContextManagerHelper;
import org.dromara.dynamictp.core.DtpRegistry;
import org.dromara.dynamictp.core.aware.MetricsAware;
import org.dromara.dynamictp.core.converter.ExecutorConverter;
import org.dromara.dynamictp.core.support.ExecutorWrapper;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="dynamic-tp")
public class DtpEndpoint {
    @ReadOperation
    public List<Metrics> invoke() {
        ArrayList metricsList = Lists.newArrayList();
        DtpRegistry.getAllExecutorNames().forEach(x -> {
            ExecutorWrapper wrapper = DtpRegistry.getExecutorWrapper((String)x);
            metricsList.add(ExecutorConverter.toMetrics((ExecutorWrapper)wrapper));
        });
        Map handlerMap = ContextManagerHelper.getBeansOfType(MetricsAware.class);
        if (MapUtils.isNotEmpty((Map)handlerMap)) {
            handlerMap.forEach((k, v) -> metricsList.addAll(v.getMultiPoolStats()));
        }
        JvmStats jvmStats = new JvmStats();
        Runtime runtime = Runtime.getRuntime();
        jvmStats.setMaxMemory(FileUtil.readableFileSize((long)runtime.maxMemory()));
        jvmStats.setTotalMemory(FileUtil.readableFileSize((long)runtime.totalMemory()));
        jvmStats.setFreeMemory(FileUtil.readableFileSize((long)runtime.freeMemory()));
        jvmStats.setUsableMemory(FileUtil.readableFileSize((long)(runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory())));
        metricsList.add(jvmStats);
        return metricsList;
    }
}

