/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.starter.extension.notify.email.autoconfigure;

import org.dromara.dynamictp.core.notifier.DtpNotifier;
import org.dromara.dynamictp.extension.notify.email.DtpEmailNotifier;
import org.dromara.dynamictp.extension.notify.email.EmailNotifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.javamail.JavaMailSender;
import org.thymeleaf.TemplateEngine;

@Configuration
@ConditionalOnProperty(prefix="spring.mail", name={"host"})
public class NotifyEmailAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public EmailNotifier emailNotifier(JavaMailSender javaMailSender, TemplateEngine templateEngine) {
        return new EmailNotifier(javaMailSender, templateEngine);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={EmailNotifier.class})
    public DtpNotifier dtpEmailNotifier() {
        return new DtpEmailNotifier();
    }
}

