/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.spring.annotation;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.commons.collections4.CollectionUtils;
import org.dromara.dynamictp.common.em.QueueTypeEnum;
import org.dromara.dynamictp.common.entity.DtpExecutorProps;
import org.dromara.dynamictp.common.entity.NotifyItem;
import org.dromara.dynamictp.common.properties.DtpProperties;
import org.dromara.dynamictp.core.executor.ExecutorType;
import org.dromara.dynamictp.core.executor.NamedThreadFactory;
import org.dromara.dynamictp.core.executor.eager.EagerDtpExecutor;
import org.dromara.dynamictp.core.executor.eager.TaskQueue;
import org.dromara.dynamictp.core.executor.priority.PriorityDtpExecutor;
import org.dromara.dynamictp.core.reject.RejectHandlerGetter;
import org.dromara.dynamictp.core.support.binder.BinderHelper;
import org.dromara.dynamictp.core.support.task.wrapper.TaskWrappers;
import org.dromara.dynamictp.spring.util.BeanRegistrationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

public class DtpBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(DtpBeanDefinitionRegistrar.class);
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        DtpProperties dtpProperties = DtpProperties.getInstance();
        BinderHelper.bindDtpProperties((Object)this.environment, (DtpProperties)dtpProperties);
        List executors = dtpProperties.getExecutors();
        if (CollectionUtils.isEmpty((Collection)executors)) {
            log.info("DynamicTp registrar, no executors are configured.");
            return;
        }
        executors.forEach(e -> {
            if (!e.isAutoCreate()) {
                return;
            }
            Class executorTypeClass = ExecutorType.getClass((String)e.getExecutorType());
            Map<String, Object> propertyValues = this.buildPropertyValues((DtpExecutorProps)e);
            Object[] args = this.buildConstructorArgs(executorTypeClass, (DtpExecutorProps)e);
            BeanRegistrationUtil.register(registry, e.getThreadPoolName(), executorTypeClass, propertyValues, args);
        });
    }

    private Map<String, Object> buildPropertyValues(DtpExecutorProps props) {
        HashMap propertyValues = Maps.newHashMap();
        propertyValues.put("threadPoolName", props.getThreadPoolName());
        propertyValues.put("threadPoolAliasName", props.getThreadPoolAliasName());
        propertyValues.put("allowCoreThreadTimeOut", props.isAllowCoreThreadTimeOut());
        propertyValues.put("waitForTasksToCompleteOnShutdown", props.isWaitForTasksToCompleteOnShutdown());
        propertyValues.put("awaitTerminationSeconds", props.getAwaitTerminationSeconds());
        propertyValues.put("preStartAllCoreThreads", props.isPreStartAllCoreThreads());
        propertyValues.put("rejectHandlerType", props.getRejectedHandlerType());
        propertyValues.put("rejectEnhanced", props.isRejectEnhanced());
        propertyValues.put("runTimeout", props.getRunTimeout());
        propertyValues.put("tryInterrupt", props.isTryInterrupt());
        propertyValues.put("queueTimeout", props.getQueueTimeout());
        List notifyItems = NotifyItem.mergeAllNotifyItems((List)props.getNotifyItems());
        propertyValues.put("notifyItems", notifyItems);
        propertyValues.put("platformIds", props.getPlatformIds());
        propertyValues.put("notifyEnabled", props.isNotifyEnabled());
        List taskWrappers = TaskWrappers.getInstance().getByNames(props.getTaskWrapperNames());
        propertyValues.put("taskWrappers", taskWrappers);
        propertyValues.put("pluginNames", props.getPluginNames());
        propertyValues.put("awareNames", props.getAwareNames());
        return propertyValues;
    }

    private Object[] buildConstructorArgs(Class<?> clazz, DtpExecutorProps props) {
        Object taskQueue = clazz.equals(EagerDtpExecutor.class) ? new TaskQueue(props.getQueueCapacity()) : (clazz.equals(PriorityDtpExecutor.class) ? new PriorityBlockingQueue(props.getQueueCapacity(), PriorityDtpExecutor.getRunnableComparator()) : QueueTypeEnum.buildLbq((String)props.getQueueType(), (int)props.getQueueCapacity(), (boolean)props.isFair(), (int)props.getMaxFreeMemory()));
        return new Object[]{props.getCorePoolSize(), props.getMaximumPoolSize(), props.getKeepAliveTime(), props.getUnit(), taskQueue, new NamedThreadFactory(props.getThreadNamePrefix()), RejectHandlerGetter.buildRejectedHandler((String)props.getRejectedHandlerType())};
    }
}

