/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.common.utils;

import org.dromara.easyes.common.utils.EEVersionUtils;
import org.dromara.easyes.common.utils.LogUtils;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;

public class RestHighLevelClientBuilder {
    private static final String SUPPORTED_JAR_VERSION = "7.14.0";
    private static final String SUPPORTED_CLIENT_VERSION = "7";

    public static RestHighLevelClient build(RestClientBuilder builder) {
        RestHighLevelClient restHighLevelClient = new RestHighLevelClient(builder);
        RestHighLevelClientBuilder.verify(restHighLevelClient);
        return restHighLevelClient;
    }

    private static void verify(RestHighLevelClient restHighLevelClient) {
        String jarVersion = EEVersionUtils.getJarVersion(restHighLevelClient.getClass());
        LogUtils.formatInfo("Elasticsearch jar version:%s", jarVersion);
        if (!jarVersion.equals(SUPPORTED_JAR_VERSION) && !"unknown".equals(jarVersion)) {
            LogUtils.formatError("Easy-Es supported elasticsearch and restHighLevelClient jar version is:%s ,Please resolve the dependency conflict!", SUPPORTED_JAR_VERSION);
        }
        String clientVersion = EEVersionUtils.getClientVersion(restHighLevelClient);
        LogUtils.formatInfo("Elasticsearch client version:%s", clientVersion);
        if (!clientVersion.startsWith(SUPPORTED_CLIENT_VERSION)) {
            LogUtils.formatWarn("Easy-Es supported elasticsearch client version is:%s.xx", SUPPORTED_CLIENT_VERSION);
        }
        if (!jarVersion.equals(clientVersion)) {
            LogUtils.formatWarn("Elasticsearch clientVersion:%s not equals jarVersion:%s, It does not affect your use, but we still recommend keeping it consistent!", clientVersion, jarVersion);
        }
    }

    private RestHighLevelClientBuilder() {
    }
}

