/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.bayesian;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dromara.easyai.randomForest.DataTable;

public class NativeBayesian {
    private DataTable dataTable;
    private final Map<Integer, Double> priorProbabilities = new HashMap<Integer, Double>();
    private final Map<String, Map<Integer, Map<Integer, Double>>> conditionalProbabilities = new HashMap<String, Map<Integer, Map<Integer, Double>>>();

    public NativeBayesian() {
    }

    public NativeBayesian(DataTable dataTable) {
        this();
        this.dataTable = dataTable;
    }

    public DataTable getDataTable() {
        return this.dataTable;
    }

    public void setDataTable(DataTable dataTable) {
        this.dataTable = dataTable;
    }

    public int classify(Object object) {
        HashMap<Integer, Double> posteriorProbabilities = new HashMap<Integer, Double>();
        try {
            List<Integer> classValues = this.dataTable.getTable().get(this.dataTable.getKey());
            HashSet<Integer> uniqueClasses = new HashSet<Integer>(classValues);
            Iterator iterator = uniqueClasses.iterator();
            while (iterator.hasNext()) {
                int classValue = (Integer)iterator.next();
                double posteriorProb = this.priorProbabilities.get(classValue);
                for (String feature : this.dataTable.getKeyType()) {
                    if (feature.equals(this.dataTable.getKey())) continue;
                    String methodName = "get" + feature.substring(0, 1).toUpperCase() + feature.substring(1);
                    Method method = object.getClass().getMethod(methodName, new Class[0]);
                    int featureValue = (Integer)method.invoke(object, new Object[0]);
                    posteriorProb *= this.conditionalProbabilities.get(feature).get(classValue).getOrDefault(featureValue, 0.0).doubleValue();
                }
                posteriorProbabilities.put(classValue, posteriorProb);
            }
            int maxClass = -1;
            double maxProb = -1.0;
            for (Map.Entry entry : posteriorProbabilities.entrySet()) {
                if (!((Double)entry.getValue() > maxProb)) continue;
                maxProb = (Double)entry.getValue();
                maxClass = (Integer)entry.getKey();
            }
            return maxClass;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void study() {
        List<Integer> classValues = this.dataTable.getTable().get(this.dataTable.getKey());
        HashMap<Integer, Integer> classCounts = new HashMap<Integer, Integer>();
        Iterator<Object> iterator = classValues.iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            classCounts.put(n, classCounts.getOrDefault(n, 0) + 1);
        }
        for (Map.Entry entry : classCounts.entrySet()) {
            this.priorProbabilities.put((Integer)entry.getKey(), (double)((Integer)entry.getValue()).intValue() / (double)this.dataTable.getLength());
        }
        for (String string : this.dataTable.getKeyType()) {
            if (string.equals(this.dataTable.getKey())) continue;
            HashMap<Integer, Map> featureCounts = new HashMap<Integer, Map>();
            List<Integer> featureValues = this.dataTable.getTable().get(string);
            for (int i = 0; i < this.dataTable.getLength(); ++i) {
                int classValue = classValues.get(i);
                int featureValue = featureValues.get(i);
                featureCounts.computeIfAbsent(classValue, k -> new HashMap()).put(featureValue, ((Map)featureCounts.get(classValue)).getOrDefault(featureValue, 0) + 1);
            }
            HashMap featureProbabilities = new HashMap();
            for (Map.Entry entry : featureCounts.entrySet()) {
                int classValue = (Integer)entry.getKey();
                Map counts = (Map)entry.getValue();
                HashMap<Integer, Double> probabilities = new HashMap<Integer, Double>();
                for (Map.Entry countEntry : counts.entrySet()) {
                    int featureValue = (Integer)countEntry.getKey();
                    int count = (Integer)countEntry.getValue();
                    probabilities.put(featureValue, (double)count / (double)((Integer)classCounts.get(classValue)).intValue());
                }
                featureProbabilities.put(classValue, probabilities);
            }
            this.conditionalProbabilities.put(string, featureProbabilities);
        }
    }
}

