/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.dromara.easyai.matrixTools.Matrix;
import org.dromara.easyai.tools.RgbRegression;

public class RGBNorm {
    private float[] rgbAll;
    private float norm;
    private int nub;
    private float[] rgb;
    private float[] rgbUp;
    private List<float[]> rgbs = new ArrayList<float[]>();
    private List<Float> powers = new ArrayList<Float>();
    private RgbRegression rgbRegression;
    private int len;
    private float varAll = 1.0f;
    private Matrix avgMatrix;
    private Matrix varMatrix;
    private float gmParameter;
    private float probabilitySigma = 0.0f;

    public float getVarAll() {
        return this.varAll;
    }

    public Matrix getAvgMatrix() {
        return this.avgMatrix;
    }

    public Matrix getVarMatrix() {
        return this.varMatrix;
    }

    public List<float[]> getRgbs() {
        return this.rgbs;
    }

    public RgbRegression getRgbRegression() {
        return this.rgbRegression;
    }

    public void setRgbRegression(RgbRegression rgbRegression) {
        this.rgbRegression = rgbRegression;
    }

    public RGBNorm(float[] rgb, int len) {
        this.len = len;
        this.rgbAll = new float[len];
        this.rgb = new float[len];
        this.rgbUp = rgb;
        this.gmParameter = new Random().nextFloat();
    }

    public RGBNorm() {
    }

    public void syn() {
        this.rgbUp = this.rgb;
    }

    public void clearRGB() {
        this.probabilitySigma = 0.0f;
        this.rgbs.clear();
        this.powers.clear();
    }

    public void setGmFeature(float[] feature, float probability) {
        this.rgbs.add(feature);
        this.powers.add(Float.valueOf(probability));
        this.probabilitySigma = probability + this.probabilitySigma;
    }

    public void clear() {
        this.rgbAll = new float[this.len];
        this.nub = 0;
        for (int i = 0; i < this.rgb.length; ++i) {
            this.rgbUp[i] = this.rgb[i];
        }
        this.rgbs.clear();
    }

    public int getNub() {
        return this.nub;
    }

    public boolean compare() {
        boolean isNext = false;
        for (int i = 0; i < this.rgb.length; ++i) {
            if (this.rgb[i] == this.rgbUp[i]) continue;
            isNext = true;
            break;
        }
        return isNext;
    }

    public float getEDist(float[] x) {
        float[] y = new float[x.length];
        for (int i = 0; i < y.length; ++i) {
            y[i] = x[i] - this.rgbUp[i];
        }
        float sigma = 0.0f;
        for (int i = 0; i < y.length; ++i) {
            sigma += (float)Math.pow(y[i], 2.0);
        }
        return (float)Math.sqrt(sigma);
    }

    public void setColor(float[] rgb) {
        for (int i = 0; i < rgb.length; ++i) {
            this.rgbAll[i] = this.rgbAll[i] + rgb[i];
        }
        this.rgbs.add(rgb);
        ++this.nub;
    }

    private Matrix average(Matrix matrix) throws Exception {
        int i;
        int x = matrix.getX();
        int y = matrix.getY();
        Matrix avgMatrix = new Matrix(x, 1);
        boolean isPower = this.powers.size() > 1;
        for (i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                float power = !isPower ? 1.0f : this.powers.get(j).floatValue();
                float nub = avgMatrix.getNumber(i, 0) + matrix.getNumber(i, j) * power;
                avgMatrix.setNub(i, 0, nub);
            }
        }
        for (i = 0; i < x; ++i) {
            float nub = this.probabilitySigma > 0.0f ? avgMatrix.getNumber(i, 0) / this.probabilitySigma : avgMatrix.getNumber(i, 0) / (float)y;
            avgMatrix.setNub(i, 0, nub);
        }
        return avgMatrix;
    }

    private Matrix getVariance(Matrix matrix, Matrix avgMatrix) throws Exception {
        int i;
        int x = matrix.getX();
        int y = matrix.getY();
        Matrix varMatrix = new Matrix(x, 1);
        boolean isPower = this.powers.size() > 1;
        for (i = 0; i < x; ++i) {
            float avg = avgMatrix.getNumber(i, 0);
            for (int j = 0; j < y; ++j) {
                float power = !isPower ? 1.0f : this.powers.get(j).floatValue();
                float sub = (float)Math.pow(matrix.getNumber(i, j) - avg, 2.0) * power;
                varMatrix.setNub(i, 0, sub + varMatrix.getNumber(i, 0));
            }
        }
        for (i = 0; i < x; ++i) {
            float nub = this.probabilitySigma > 0.0f ? varMatrix.getNumber(i, 0) / this.probabilitySigma : varMatrix.getNumber(i, 0) / (float)y;
            varMatrix.setNub(i, 0, nub);
        }
        return varMatrix;
    }

    public float[] getFeature() throws Exception {
        int avgLen = this.avgMatrix.getX();
        int length = avgLen * 2 + 1;
        float[] feature = new float[length];
        for (int i = 0; i < length - 1; ++i) {
            if (i < avgLen) {
                feature[i] = this.avgMatrix.getNumber(i, 0);
                continue;
            }
            int t = i - avgLen;
            feature[i] = this.varMatrix.getNumber(t, 0);
        }
        feature[length - 1] = this.gmParameter;
        return feature;
    }

    public void insertFeature(float[] feature) throws Exception {
        int length = feature.length - 1;
        int size = length / 2;
        this.avgMatrix = new Matrix(size, 1);
        this.varMatrix = new Matrix(size, 1);
        this.gmParameter = feature[length];
        this.varAll = 1.0f;
        for (int i = 0; i < length; ++i) {
            if (i < size) {
                this.avgMatrix.setNub(i, 0, feature[i]);
                continue;
            }
            int t = i - size;
            float var = feature[i];
            this.varMatrix.setNub(t, 0, var);
            this.varAll *= (float)Math.sqrt(var);
        }
    }

    public void gm() throws Exception {
        int size = this.rgbs.size();
        if (size > 0) {
            int i;
            Matrix matrix = new Matrix(this.len, size);
            for (i = 0; i < size; ++i) {
                float[] rgb = this.rgbs.get(i);
                for (int j = 0; j < this.len; ++j) {
                    matrix.setNub(j, i, rgb[j]);
                }
            }
            this.avgMatrix = this.average(matrix);
            this.varMatrix = this.getVariance(matrix, this.avgMatrix);
            this.varAll = 1.0f;
            for (i = 0; i < this.len; ++i) {
                float var = (float)Math.sqrt(this.varMatrix.getNumber(i, 0));
                this.varAll *= var;
            }
            if (this.probabilitySigma > 0.0f) {
                this.gmParameter = this.probabilitySigma / (float)this.rgbs.size();
            }
        }
    }

    public float getGMProbability(float[] feature) throws Exception {
        float zSigma = 0.0f;
        int size = feature.length;
        for (int i = 0; i < size; ++i) {
            float sub = (float)Math.pow(feature[i] - this.avgMatrix.getNumber(i, 0), 2.0) / this.varMatrix.getNumber(i, 0);
            zSigma = sub + zSigma;
        }
        float one = 1.0f / ((float)Math.pow((float)Math.sqrt(6.2831854820251465), size) * this.varAll);
        float two = (float)Math.exp((double)zSigma * -0.5);
        float n = one * two * this.gmParameter;
        return n;
    }

    public float getGmParameter() {
        return this.gmParameter;
    }

    public void setGmParameter(float gmParameter) {
        this.gmParameter = gmParameter;
    }

    public void norm() {
        float sigma = 0.0f;
        if (this.nub > 0) {
            for (int i = 0; i < this.rgb.length; ++i) {
                float rgbc;
                this.rgb[i] = rgbc = this.rgbAll[i] / (float)this.nub;
                sigma += (float)Math.pow(rgbc, 2.0);
            }
            this.norm = (float)Math.sqrt(sigma);
        }
    }

    public void finish() {
        RGBListSort rgbListSort = new RGBListSort();
        Collections.sort(this.rgbs, rgbListSort);
    }

    public float getNorm() {
        return this.norm;
    }

    public float[] getRgb() {
        return this.rgb;
    }

    class RGBListSort
    implements Comparator<float[]> {
        RGBListSort() {
        }

        @Override
        public int compare(float[] o1, float[] o2) {
            float o1Norm = 0.0f;
            float o2Norm = 0.0f;
            for (int i = 0; i < o1.length; ++i) {
                o1Norm += (float)Math.pow(o1[i], 2.0);
                o2Norm += (float)Math.pow(o2[i], 2.0);
            }
            if (o1Norm > o2Norm) {
                return 1;
            }
            if (o1Norm < o2Norm) {
                return -1;
            }
            return 0;
        }
    }
}

