/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.entity;

import org.dromara.easyai.matrixTools.Matrix;
import org.dromara.easyai.matrixTools.MatrixOperation;

public class ThreeChannelMatrix {
    private Matrix matrixR;
    private Matrix matrixG;
    private Matrix matrixB;
    private Matrix H;
    private int x;
    private int y;
    private final MatrixOperation matrixOperation = new MatrixOperation();

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public float getDist(ThreeChannelMatrix th) throws Exception {
        if (th.getX() == this.x && th.getY() == this.y) {
            float subR = this.matrixOperation.getEDistByMatrix(this.matrixR, th.getMatrixR());
            float subG = this.matrixOperation.getEDistByMatrix(this.matrixG, th.getMatrixG());
            float subB = this.matrixOperation.getEDistByMatrix(this.matrixB, th.getMatrixB());
            return (subR + subB + subG) / 3.0f;
        }
        throw new Exception("\u56fe\u50cf\u5c3a\u5bf8\u5927\u5c0f\u4e0d\u5339\u914d\uff0c\u672c\u56fe\u50cf\u5c3a\u5bf8x\u662f\uff1a" + this.x + ",y:" + this.y + "\u3002\u5f85\u5339\u914d\u5c3a\u5bf8\u56fe\u50cf x:" + th.getX() + ",y:" + th.getY());
    }

    public void grayscaleScale(float toR, float toG, float toB) throws Exception {
        MatrixOperation matrixOperation = new MatrixOperation();
        float avgR = this.matrixR.getAVG();
        float avgG = this.matrixG.getAVG();
        float avgB = this.matrixB.getAVG();
        float rk = toR / avgR;
        float gk = toG / avgG;
        float bk = toB / avgB;
        matrixOperation.mathMul(this.matrixR, rk);
        matrixOperation.mathMul(this.matrixG, gk);
        matrixOperation.mathMul(this.matrixB, bk);
    }

    private Matrix createGaussianKern(float sd, int kerSize) throws Exception {
        float a = 1.0f / ((float)Math.PI * 2 * (float)Math.pow(sd, 2.0));
        Matrix matrix = new Matrix(kerSize, kerSize);
        int half = kerSize / 2;
        for (int i = 0; i < kerSize; ++i) {
            for (int j = 0; j < kerSize; ++j) {
                int xIndex = i - half;
                int yIndex = j - half;
                float b = (float)Math.exp(-((float)Math.pow(xIndex, 2.0) + (float)Math.pow(yIndex, 2.0)) / (2.0f * (float)Math.pow(sd, 2.0)));
                matrix.setNub(i, j, a * b);
            }
        }
        float sigma = matrix.getSigma();
        this.matrixOperation.mathDiv(matrix, sigma);
        return matrix;
    }

    public Matrix CalculateAvgGrayscale() throws Exception {
        Matrix matrix = new Matrix(this.x, this.y);
        for (int i = 0; i < this.x; ++i) {
            for (int j = 0; j < this.y; ++j) {
                float value = (this.matrixR.getNumber(i, j) + this.matrixG.getNumber(i, j) + this.matrixB.getNumber(i, j)) / 3.0f;
                matrix.setNub(i, j, value);
            }
        }
        return matrix;
    }

    public ThreeChannelMatrix gaussianVague(float sd, int kerSize, boolean scaleWidth, float scaleSize) throws Exception {
        if (kerSize % 2 != 1) {
            throw new Exception("\u9ad8\u65af\u6838\u5927\u5c0f\u5fc5\u987b\u4e3a\u5947\u6570");
        }
        ThreeChannelMatrix threeChannelMatrix = this.scale(scaleWidth, scaleSize);
        Matrix matrixR = threeChannelMatrix.getMatrixR();
        Matrix matrixG = threeChannelMatrix.getMatrixG();
        Matrix matrixB = threeChannelMatrix.getMatrixB();
        Matrix gaussianMatrix = this.createGaussianKern(sd, kerSize);
        Matrix gr = this.conv(matrixR, gaussianMatrix, kerSize);
        Matrix gg = this.conv(matrixG, gaussianMatrix, kerSize);
        Matrix gb = this.conv(matrixB, gaussianMatrix, kerSize);
        ThreeChannelMatrix vague = new ThreeChannelMatrix();
        vague.setX(gr.getX());
        vague.setY(gr.getY());
        vague.setMatrixR(gr);
        vague.setMatrixG(gg);
        vague.setMatrixB(gb);
        return vague;
    }

    private float getConv(Matrix conv, Matrix gaussianMatrix) throws Exception {
        int x = gaussianMatrix.getX();
        int y = gaussianMatrix.getY();
        float sigma = 0.0f;
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                float value = conv.getNumber(i, j) * gaussianMatrix.getNumber(i, j);
                sigma += value;
            }
        }
        return sigma;
    }

    private Matrix conv(Matrix matrix, Matrix gaussianMatrix, int kerSize) throws Exception {
        int x = matrix.getX();
        int y = matrix.getY();
        int half = kerSize / 2;
        Matrix convMatrix = new Matrix(x - half * 2, y - half * 2);
        for (int i = half; i < x - half; ++i) {
            for (int j = half; j < y - half; ++j) {
                Matrix conv = matrix.getSonOfMatrix(i - half, j - half, kerSize, kerSize);
                float value = this.getConv(conv, gaussianMatrix);
                convMatrix.setNub(i - half, j - half, value);
            }
        }
        return convMatrix;
    }

    public Matrix getLBPMatrix() throws Exception {
        Matrix addMatrix = new Matrix(this.x, this.y);
        for (int i = 0; i < this.x; ++i) {
            for (int j = 0; j < this.y; ++j) {
                float value = this.matrixR.getNumber(i, j) + this.matrixG.getNumber(i, j) + this.matrixB.getNumber(i, j);
                addMatrix.setNub(i, j, value);
            }
        }
        return this.matrixOperation.lbpMatrix(addMatrix);
    }

    public void standardization() throws Exception {
        this.standardizationMatrix(this.matrixR);
        this.standardizationMatrix(this.matrixG);
        this.standardizationMatrix(this.matrixB);
    }

    private void standardizationMatrix(Matrix matrix) throws Exception {
        float avg = matrix.getAVG();
        float sigma = 0.0f;
        float size = this.x * this.y;
        for (int i = 0; i < this.x; ++i) {
            for (int j = 0; j < this.y; ++j) {
                sigma += (float)Math.pow(matrix.getNumber(i, j) - avg, 2.0);
            }
        }
        float b = (float)Math.sqrt(sigma /= size);
        for (int i = 0; i < this.x; ++i) {
            for (int j = 0; j < this.y; ++j) {
                float value = (matrix.getNumber(i, j) - avg) / b;
                matrix.setNub(i, j, value);
            }
        }
    }

    public ThreeChannelMatrix scale(boolean scaleWidth, float size) throws Exception {
        float value = scaleWidth ? (float)this.y / size : (float)this.x / size;
        int narrowX = (int)((float)this.x / value);
        int narrowY = (int)((float)this.y / value);
        if (scaleWidth) {
            narrowY = (int)size;
        } else {
            narrowX = (int)size;
        }
        ThreeChannelMatrix scaleMatrix = new ThreeChannelMatrix();
        scaleMatrix.setX(narrowX);
        scaleMatrix.setY(narrowY);
        Matrix matrixCR = new Matrix(narrowX, narrowY);
        Matrix matrixCG = new Matrix(narrowX, narrowY);
        Matrix matrixCB = new Matrix(narrowX, narrowY);
        Matrix matrixCH = new Matrix(narrowX, narrowY);
        scaleMatrix.setMatrixR(matrixCR);
        scaleMatrix.setMatrixG(matrixCG);
        scaleMatrix.setMatrixB(matrixCB);
        scaleMatrix.setH(matrixCH);
        for (int i = 0; i < narrowX; ++i) {
            for (int j = 0; j < narrowY; ++j) {
                int indexX = (int)((float)i * value);
                int indexY = (int)((float)j * value);
                matrixCR.setNub(i, j, this.matrixR.getNumber(indexX, indexY));
                matrixCG.setNub(i, j, this.matrixG.getNumber(indexX, indexY));
                matrixCB.setNub(i, j, this.matrixB.getNumber(indexX, indexY));
            }
        }
        return scaleMatrix;
    }

    public void add(float nub, boolean add) throws Exception {
        if (add) {
            this.matrixOperation.mathAdd(this.matrixR, nub);
            this.matrixOperation.mathAdd(this.matrixG, nub);
            this.matrixOperation.mathAdd(this.matrixB, nub);
        } else {
            this.matrixOperation.mathSub(this.matrixR, nub);
            this.matrixOperation.mathSub(this.matrixG, nub);
            this.matrixOperation.mathSub(this.matrixB, nub);
        }
    }

    public void center() throws Exception {
        this.center(this.matrixR);
        this.center(this.matrixG);
        this.center(this.matrixB);
    }

    private void center(Matrix matrix) throws Exception {
        float avg = matrix.getAVG();
        this.matrixOperation.mathSub(matrix, avg);
    }

    public ThreeChannelMatrix copy() throws Exception {
        ThreeChannelMatrix copyThreeChannelMatrix = new ThreeChannelMatrix();
        copyThreeChannelMatrix.setX(this.x);
        copyThreeChannelMatrix.setY(this.y);
        Matrix matrixCR = new Matrix(this.x, this.y);
        Matrix matrixCG = new Matrix(this.x, this.y);
        Matrix matrixCB = new Matrix(this.x, this.y);
        for (int i = 0; i < this.x; ++i) {
            for (int j = 0; j < this.y; ++j) {
                matrixCR.setNub(i, j, this.matrixR.getNumber(i, j));
                matrixCG.setNub(i, j, this.matrixG.getNumber(i, j));
                matrixCB.setNub(i, j, this.matrixB.getNumber(i, j));
            }
        }
        copyThreeChannelMatrix.setMatrixR(matrixCR);
        copyThreeChannelMatrix.setMatrixG(matrixCG);
        copyThreeChannelMatrix.setMatrixB(matrixCB);
        return copyThreeChannelMatrix;
    }

    public void fill(int x, int y, ThreeChannelMatrix fillThreeChannelMatrix) throws Exception {
        int xIndex = x + fillThreeChannelMatrix.getX();
        int yIndex = y + fillThreeChannelMatrix.getY();
        Matrix matrixFR = fillThreeChannelMatrix.getMatrixR();
        Matrix matrixFG = fillThreeChannelMatrix.getMatrixG();
        Matrix matrixFB = fillThreeChannelMatrix.getMatrixB();
        if (xIndex <= this.x && yIndex <= this.y) {
            for (int i = x; i < xIndex; ++i) {
                for (int j = y; j < yIndex; ++j) {
                    this.matrixR.setNub(i, j, matrixFR.getNumber(i - x, j - y));
                    this.matrixG.setNub(i, j, matrixFG.getNumber(i - x, j - y));
                    this.matrixB.setNub(i, j, matrixFB.getNumber(i - x, j - y));
                }
            }
        } else {
            throw new Exception("The filled image goes beyond the boundary !");
        }
    }

    public ThreeChannelMatrix cutChannel(int x, int y, int XSize, int YSize) throws Exception {
        ThreeChannelMatrix threeChannelMatrix = new ThreeChannelMatrix();
        threeChannelMatrix.setX(XSize);
        threeChannelMatrix.setY(YSize);
        int xLen = this.matrixR.getX();
        int yLen = this.matrixR.getY();
        if (x < 0 || y < 0 || x + XSize > xLen || y + YSize > yLen) {
            throw new Exception("size out,xLen:" + xLen + ",yLen:" + yLen + ",x:" + x + ",y:" + y + ",xSize:" + (x + XSize) + ",ySize:" + (y + YSize));
        }
        Matrix matrixR = this.matrixR.getSonOfMatrix(x, y, XSize, YSize);
        Matrix matrixG = this.matrixG.getSonOfMatrix(x, y, XSize, YSize);
        Matrix matrixB = this.matrixB.getSonOfMatrix(x, y, XSize, YSize);
        Matrix matrixH = this.H.getSonOfMatrix(x, y, XSize, YSize);
        threeChannelMatrix.setX(XSize);
        threeChannelMatrix.setY(YSize);
        threeChannelMatrix.setMatrixR(matrixR);
        threeChannelMatrix.setMatrixG(matrixG);
        threeChannelMatrix.setMatrixB(matrixB);
        threeChannelMatrix.setH(matrixH);
        return threeChannelMatrix;
    }

    public Matrix getH() {
        return this.H;
    }

    public void setH(Matrix h) {
        this.H = h;
    }

    public Matrix getMatrixR() {
        return this.matrixR;
    }

    public void setMatrixR(Matrix matrixR) {
        this.matrixR = matrixR;
    }

    public Matrix getMatrixG() {
        return this.matrixG;
    }

    public void setMatrixG(Matrix matrixG) {
        this.matrixG = matrixG;
    }

    public Matrix getMatrixB() {
        return this.matrixB;
    }

    public void setMatrixB(Matrix matrixB) {
        this.matrixB = matrixB;
    }
}

