/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.matrixTools;

import java.util.ArrayList;
import java.util.List;
import org.dromara.easyai.matrixTools.MatrixOperation;

public class Matrix
extends MatrixOperation {
    private float[] matrix;
    private int x;
    private int y;
    private boolean isRowVector = false;
    private boolean isVector = false;
    private boolean isZero = false;
    private List<Coordinate> coordinateRoot;
    private float defNub = 0.0f;

    public float[] getCudaMatrix() {
        return this.matrix;
    }

    public Float[] getMatrixModel() {
        Float[] matrixModel = new Float[this.matrix.length];
        for (int i = 0; i < this.matrix.length; ++i) {
            matrixModel[i] = Float.valueOf(this.matrix[i]);
        }
        return matrixModel;
    }

    public void insertMatrixModel(Float[] matrixModel) {
        this.matrix = new float[matrixModel.length];
        for (int i = 0; i < this.matrix.length; ++i) {
            this.matrix[i] = matrixModel[i].floatValue();
        }
    }

    public void setCudaMatrix(float[] cudaMatrix, int x, int y) {
        this.matrix = cudaMatrix;
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Matrix(int x, int y) {
        this.matrix = new float[x * y];
        this.x = x;
        this.y = y;
        this.setState(x, y);
    }

    private void setState(int x, int y) {
        if (x == 1 && y == 1) {
            this.isZero = true;
            this.isVector = true;
        } else if (x == 1 || y == 1) {
            this.isVector = true;
            this.isRowVector = x == 1;
        }
    }

    public float getSigma() throws Exception {
        float sigma = 0.0f;
        for (int i = 0; i < this.x; ++i) {
            for (int j = 0; j < this.y; ++j) {
                sigma += this.getNumber(i, j);
            }
        }
        return sigma;
    }

    public float getAVG() throws Exception {
        float sigma = 0.0f;
        int s = this.x * this.y;
        for (int i = 0; i < this.x; ++i) {
            for (int j = 0; j < this.y; ++j) {
                sigma += this.getNumber(i, j);
            }
        }
        return sigma /= (float)s;
    }

    public float[][] getMatrix() throws Exception {
        float[][] matrix = new float[this.x][this.y];
        for (int i = 0; i < this.x; ++i) {
            for (int j = 0; j < this.y; ++j) {
                matrix[i][j] = this.getNumber(i, j);
            }
        }
        return matrix;
    }

    public boolean isRowVector() {
        return this.isRowVector;
    }

    public boolean isVector() {
        return this.isVector;
    }

    public boolean isZero() {
        return this.isZero;
    }

    public void clear() {
        this.matrix = new float[this.x * this.y];
    }

    public Matrix(int x, int y, String matr) throws Exception {
        this.matrix = new float[x * y];
        this.x = x;
        this.y = y;
        this.setState(x, y);
        this.setAll(matr);
    }

    private boolean isDo(Coordinate coordinates, int i, int j) {
        boolean isOk = false;
        if (coordinates != null) {
            for (Coordinate coordinate : coordinates.coordinateList) {
                if (coordinate.x != i || coordinate.y != j) continue;
                isOk = true;
                break;
            }
        }
        return isOk;
    }

    private boolean findRout(Coordinate coordinate, int j, int initi, boolean isDown) {
        for (int i = 0; i < this.x && isDown; ++i) {
            boolean isOk;
            int row = i;
            if (coordinate == null) {
                row = initi;
            }
            boolean bl = isOk = this.isNext(coordinate, row, true) && !this.isDo(coordinate, row, j);
            if (isOk) {
                Coordinate coordinateNext = new Coordinate(coordinate, row, j);
                if (coordinate != null) {
                    coordinate.coordinateList.add(coordinateNext);
                } else {
                    this.coordinateRoot.add(coordinateNext);
                }
                if (coordinateNext.y < this.y - 1) {
                    isDown = this.findRout(coordinateNext, ++j, initi, isDown);
                    continue;
                }
                if (coordinate != null && coordinateNext.y > 1 && coordinateNext.x == this.x - 1) {
                    isDown = this.findRout(coordinate.father, --j, initi, isDown);
                    continue;
                }
                if (coordinateNext.y != 1) continue;
                isDown = false;
                break;
            }
            if (i == this.x - 1 && j > 1) {
                isDown = this.findRout(coordinate.father, --j, initi, isDown);
                continue;
            }
            if (j != 1 || i != this.x - 1) continue;
            isDown = false;
            break;
        }
        return isDown;
    }

    private boolean isNext(Coordinate coordinate, int i, boolean isOk) {
        if (coordinate == null) {
            return true;
        }
        if (isOk) {
            if (coordinate.x != i) {
                isOk = this.isNext(coordinate.father, i, true);
            } else {
                return false;
            }
        }
        return isOk;
    }

    private void defCalculation(List<Coordinate> coordinates) throws Exception {
        for (Coordinate coordinate : coordinates) {
            if (!coordinate.coordinateList.isEmpty()) {
                this.defCalculation(coordinate.coordinateList);
                continue;
            }
            this.mulFather(coordinate, 1.0f, new ArrayList<Coordinate>());
        }
    }

    private float mulFather(Coordinate coordinate, float element, List<Coordinate> div) throws Exception {
        div.add(coordinate);
        element = this.getNumber(coordinate.x, coordinate.y) * element;
        if (coordinate.father != null) {
            element = this.mulFather(coordinate.father, element, div);
        } else {
            this.defNub = this.parity(div) ? (this.defNub += element) : (this.defNub -= element);
            div.clear();
            element = 1.0f;
        }
        return element;
    }

    public float getDet() throws Exception {
        if (this.x == this.y) {
            this.coordinateRoot = new ArrayList<Coordinate>();
            for (int i = 0; i < this.x; ++i) {
                this.findRout(null, 0, i, true);
            }
        } else {
            throw new Exception("Matrix is not Square");
        }
        this.defCalculation(this.coordinateRoot);
        return this.defNub;
    }

    private boolean parity(List<Coordinate> list) {
        int cloInv;
        boolean parity = true;
        float[] row = new float[list.size()];
        float[] clo = new float[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            row[i] = list.get((int)i).x + 1;
            clo[i] = list.get((int)i).y + 1;
        }
        int rowInv = this.inverseNumber(row);
        int inverserNumber = rowInv + (cloInv = this.inverseNumber(clo));
        if (inverserNumber % 2 != 0) {
            parity = false;
        }
        return parity;
    }

    public void setAll(String messages) throws Exception {
        String[] message = messages.split("#");
        if (this.x == message.length) {
            for (int i = 0; i < message.length; ++i) {
                String mes = message[i];
                String[] me = mes.substring(1, mes.length() - 1).split(",");
                if (this.y == me.length) {
                    this.y = me.length;
                    for (int j = 0; j < this.y; ++j) {
                        this.setNub(i, j, Float.parseFloat(me[j]));
                    }
                    continue;
                }
                this.matrix = null;
                throw new Exception("matrix column is not equals");
            }
        } else {
            throw new Exception("matrix row is not equals");
        }
    }

    public Matrix getSonOfMatrix(int x, int y, int xSize, int ySize) {
        Matrix myMatrix = new Matrix(xSize, ySize);
        int xr = 0;
        int yr = 0;
        try {
            for (int i = 0; i < xSize; ++i) {
                xr = i + x;
                for (int j = 0; j < ySize; ++j) {
                    yr = j + y;
                    if (this.x <= xr || this.y <= yr) {
                        throw new Exception("xr:" + xr + ",yr:" + yr + ",x:" + this.x + ",y:" + this.y + ",xSize:" + xSize + ",ySize:" + ySize + ",x:" + x + ",y:" + y);
                    }
                    myMatrix.setNub(i, j, this.getNumber(xr, yr));
                }
            }
        }
        catch (Exception e) {
            System.out.println("xr:" + xr + ",yr:" + yr);
            e.printStackTrace();
        }
        return myMatrix;
    }

    public Matrix getRow(int x) throws Exception {
        Matrix myMatrix = new Matrix(1, this.y);
        for (int i = 0; i < this.y; ++i) {
            myMatrix.setNub(0, i, this.getNumber(x, i));
        }
        return myMatrix;
    }

    public Matrix getColumn(int y) throws Exception {
        Matrix myMatrix = new Matrix(this.x, 1);
        for (int i = 0; i < this.x; ++i) {
            myMatrix.setNub(i, 0, this.getNumber(i, y));
        }
        return myMatrix;
    }

    public String getString() throws Exception {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.x; ++i) {
            builder.append(i + ":[");
            for (int j = 0; j < this.y; ++j) {
                float number = this.getNumber(i, j);
                if (j == 0) {
                    builder.append(number);
                    continue;
                }
                builder.append("," + number);
            }
            builder.append("]\r\n");
        }
        return builder.toString();
    }

    public String getPositionString() throws Exception {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.x; ++i) {
            builder.append(i + ":[");
            for (int j = 0; j < this.y; ++j) {
                float number = this.getNumber(i, j);
                if (j == 0) {
                    builder.append(number);
                    continue;
                }
                builder.append("," + j + ":" + number);
            }
            builder.append("]\r\n");
        }
        return builder.toString();
    }

    public String toString() {
        try {
            return this.getString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setNub(int x, int y, float number) throws Exception {
        if (this.x <= x || this.y <= y || x < 0 || y < 0) {
            throw new Exception("setNub matrix length too little x:" + x + ",y:" + y);
        }
        this.matrix[y * this.x + x] = number;
    }

    public Matrix copy() throws Exception {
        Matrix myMatrix = new Matrix(this.x, this.y);
        for (int i = 0; i < this.x; ++i) {
            for (int j = 0; j < this.y; ++j) {
                myMatrix.setNub(i, j, this.getNumber(i, j));
            }
        }
        return myMatrix;
    }

    public float getNumber(int x, int y) throws Exception {
        if (this.x > x && this.y > y && x >= 0 && y >= 0) {
            return this.matrix[y * this.x + x];
        }
        System.out.println("x==" + x + ",y==" + y + ",maxX:" + this.x + ",maxY:" + this.y);
        throw new Exception("getNumber matrix length too little x:" + x + ",y:" + y);
    }

    public float getSigmaByVector(boolean isRow, int index) throws Exception {
        float sigma = 0.0f;
        if (index >= 0 && (isRow && this.x > index || !isRow && this.y > index)) {
            if (isRow) {
                for (int i = 0; i < this.y; ++i) {
                    sigma = this.getNumber(index, i) + sigma;
                }
            } else {
                for (int i = 0; i < this.x; ++i) {
                    sigma = this.getNumber(i, index) + sigma;
                }
            }
        } else {
            throw new Exception("index \u6570\u503c\u4e0b\u6807\u6ea2\u51fa:" + index);
        }
        return sigma;
    }

    class Coordinate {
        Coordinate father;
        List<Coordinate> coordinateList;
        int x;
        int y;

        Coordinate(Coordinate father, int x, int y) {
            this.x = x;
            this.y = y;
            this.father = father;
            this.coordinateList = new ArrayList<Coordinate>();
        }
    }
}

