/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.naturalLanguage.languageCreator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dromara.easyai.entity.DyStateModel;
import org.dromara.easyai.entity.KeyWordForSentence;
import org.dromara.easyai.gameRobot.Action;
import org.dromara.easyai.gameRobot.DynamicProgramming;
import org.dromara.easyai.gameRobot.DynamicState;
import org.dromara.easyai.naturalLanguage.languageCreator.KeyWordModel;
import org.dromara.easyai.naturalLanguage.languageCreator.WordLeft;
import org.dromara.easyai.naturalLanguage.languageCreator.WordRight;

public class CatchKeyWord {
    private final DynamicProgramming dynamicProgramming = new DynamicProgramming();
    private final List<String> keyWords = new ArrayList<String>();
    private final List<String> finishWords = new ArrayList<String>();
    private float proTh = 0.1f;
    private float maxFinishValue = 100.0f;

    public void setMaxFinishValue(float maxFinishValue) {
        this.maxFinishValue = maxFinishValue;
    }

    public void setProTh(float proTh) {
        this.proTh = proTh;
    }

    public void study(List<KeyWordForSentence> keyWordForSentenceList) throws Exception {
        int size = keyWordForSentenceList.size();
        List<DynamicState> dynamicStateList = this.dynamicProgramming.getDynamicStateList();
        DynamicState dynamicState0 = new DynamicState(new int[]{0});
        dynamicState0.setFinish(true);
        dynamicStateList.add(dynamicState0);
        for (int i = 0; i < size; ++i) {
            String keyWord;
            KeyWordForSentence keyWords = keyWordForSentenceList.get(i);
            String sentence = keyWords.getSentence();
            int startIndex = sentence.indexOf(keyWord = keyWords.getKeyWord());
            if (startIndex < 0) continue;
            this.creatID(sentence, startIndex, startIndex + keyWord.length() - 1);
        }
        Map<Integer, Action> actionMap = this.dynamicProgramming.getActionMap();
        WordRight wordRight = new WordRight(this.keyWords, this.finishWords);
        WordLeft wordLeft = new WordLeft(this.keyWords, this.finishWords);
        wordRight.setActionId(1);
        wordLeft.setActionId(2);
        actionMap.put(1, wordRight);
        actionMap.put(2, wordLeft);
        this.dynamicProgramming.gameStart();
        this.dynamicProgramming.strategyStudy();
    }

    public KeyWordModel getModel() {
        KeyWordModel keyWordModel = new KeyWordModel();
        ArrayList<DyStateModel> dyStateModels = new ArrayList<DyStateModel>();
        List<DynamicState> dynamicStateList = this.dynamicProgramming.getDynamicStateList();
        for (DynamicState dynamicState : dynamicStateList) {
            DyStateModel dyStateModel = new DyStateModel();
            dyStateModel.setId(dynamicState.getStateId()[0]);
            dyStateModel.setFinish(dynamicState.isFinish());
            dyStateModel.setValue(dynamicState.getValue());
            dyStateModels.add(dyStateModel);
        }
        keyWordModel.setDynamicStateList(dyStateModels);
        keyWordModel.setKeyWords(this.keyWords);
        return keyWordModel;
    }

    public void insertModel(KeyWordModel keyWordModel) {
        List<String> myKeyWords = keyWordModel.getKeyWords();
        List<DyStateModel> dynamicStates = keyWordModel.getDynamicStateList();
        List<DynamicState> dynamicStateList = this.dynamicProgramming.getDynamicStateList();
        this.keyWords.addAll(myKeyWords);
        for (DyStateModel modelDy : dynamicStates) {
            DynamicState dynamicState = new DynamicState(new int[]{modelDy.getId()});
            dynamicState.setValue(modelDy.getValue());
            dynamicState.setFinish(modelDy.isFinish());
            dynamicStateList.add(dynamicState);
        }
    }

    private void insertValue(WordsValue wordsValue, DynamicState dynamicState, int startIndex, int endIndex, String word) {
        if (dynamicState.getValue() > wordsValue.value) {
            wordsValue.value = dynamicState.getValue();
        }
        if (dynamicState.isFinish()) {
            wordsValue.isFinish = dynamicState.isFinish();
        }
        wordsValue.startIndex = startIndex;
        wordsValue.endIndex = endIndex;
        wordsValue.id = dynamicState.getStateId()[0];
        wordsValue.word = word;
    }

    private List<WordsValue> getBestDy(String sentence) {
        ArrayList<WordsValue> myDyList = new ArrayList<WordsValue>();
        List<DynamicState> dynamicStateList = this.dynamicProgramming.getDynamicStateList();
        int size = sentence.length();
        for (int i = 0; i < size; ++i) {
            String word;
            DynamicState dynamicState;
            WordsValue maxDy = null;
            for (int j = i; j < size && (dynamicState = this.getDynamicState(word = sentence.substring(i, j + 1), dynamicStateList)) != null && dynamicState.getValue() >= this.proTh; ++j) {
                if (maxDy == null) {
                    maxDy = new WordsValue();
                    myDyList.add(maxDy);
                }
                this.insertValue(maxDy, dynamicState, i, j, word);
            }
        }
        return myDyList;
    }

    public Set<String> getKeyWord(String sentence) {
        List<WordsValue> wordsValues = this.getBestDy(sentence);
        HashSet<String> keyWords = new HashSet<String>();
        if (!wordsValues.isEmpty()) {
            this.mergeWord(wordsValues);
            float maxValue = -2000.0f;
            float maxLeftValue = -2000.0f;
            float maxRightValue = -2000.0f;
            WordsValue maxWordsValue = null;
            WordsValue leftWordsValue = null;
            WordsValue rightWordsValue = null;
            for (WordsValue wordsValue : wordsValues) {
                if (wordsValue.isFinish) {
                    maxWordsValue = wordsValue;
                    break;
                }
                if (!(wordsValue.value > maxValue)) continue;
                maxValue = wordsValue.value;
                maxWordsValue = wordsValue;
            }
            if (maxWordsValue != null) {
                for (WordsValue wordsValue : wordsValues) {
                    boolean rightGo;
                    boolean leftGo = wordsValue.isFinish || leftWordsValue != null && !leftWordsValue.isFinish && wordsValue.value > maxLeftValue || leftWordsValue == null;
                    boolean bl = rightGo = wordsValue.isFinish || rightWordsValue != null && !rightWordsValue.isFinish && wordsValue.value > maxRightValue || rightWordsValue == null;
                    if (wordsValue.endIndex < maxWordsValue.startIndex && leftGo) {
                        maxLeftValue = wordsValue.value;
                        leftWordsValue = wordsValue;
                        continue;
                    }
                    if (wordsValue.startIndex <= maxWordsValue.endIndex || !rightGo) continue;
                    maxRightValue = wordsValue.value;
                    rightWordsValue = wordsValue;
                }
                boolean first = false;
                if (maxWordsValue.isFinish) {
                    if (leftWordsValue != null && leftWordsValue.isFinish && maxWordsValue.startIndex > leftWordsValue.endIndex + 1) {
                        keyWords.add(sentence.substring(leftWordsValue.endIndex + 1, maxWordsValue.startIndex));
                        first = true;
                    }
                    if (rightWordsValue != null && rightWordsValue.isFinish && maxWordsValue.endIndex + 1 < rightWordsValue.startIndex) {
                        keyWords.add(sentence.substring(maxWordsValue.endIndex + 1, rightWordsValue.startIndex));
                        first = true;
                    }
                    if (rightWordsValue != null && leftWordsValue != null && !rightWordsValue.isFinish && !leftWordsValue.isFinish) {
                        if (rightWordsValue.value > leftWordsValue.value) {
                            keyWords.add(sentence.substring(maxWordsValue.endIndex + 1));
                        } else {
                            keyWords.add(sentence.substring(0, maxWordsValue.startIndex));
                        }
                        first = true;
                    }
                }
                if (!first) {
                    if (rightWordsValue == null && maxWordsValue.endIndex < sentence.length() - 1) {
                        keyWords.add(sentence.substring(maxWordsValue.endIndex + 1));
                    } else if (rightWordsValue == null) {
                        keyWords.add(sentence.substring(0, maxWordsValue.startIndex));
                    }
                    if (leftWordsValue == null && maxWordsValue.startIndex > 0) {
                        keyWords.add(sentence.substring(0, maxWordsValue.startIndex));
                    } else if (leftWordsValue == null) {
                        keyWords.add(sentence.substring(maxWordsValue.endIndex + 1));
                    }
                    if (rightWordsValue != null && leftWordsValue != null) {
                        if (rightWordsValue.value > leftWordsValue.value) {
                            if (maxWordsValue.endIndex + 1 < rightWordsValue.startIndex) {
                                keyWords.add(sentence.substring(maxWordsValue.endIndex + 1, rightWordsValue.startIndex));
                            } else {
                                keyWords.add(sentence.substring(rightWordsValue.startIndex, rightWordsValue.endIndex + 1));
                            }
                        } else if (leftWordsValue.endIndex + 1 < maxWordsValue.startIndex) {
                            keyWords.add(sentence.substring(leftWordsValue.endIndex + 1, maxWordsValue.startIndex));
                        } else {
                            keyWords.add(sentence.substring(leftWordsValue.startIndex, leftWordsValue.endIndex + 1));
                        }
                    }
                }
            }
        }
        return keyWords;
    }

    private WordsValue isContinuity(int start1, int end1, int start2, int end2) {
        boolean isContinuity = false;
        WordsValue wordsValue = null;
        if (start2 >= start1 && start2 <= end1 || end2 >= start1 && end2 <= end1 || start1 >= start2 && start1 <= end2 || end1 >= start2 && end1 <= end2) {
            isContinuity = true;
        }
        if (isContinuity) {
            wordsValue = new WordsValue();
            wordsValue.isMerge = false;
            wordsValue.startIndex = Math.min(start1, start2);
            wordsValue.endIndex = Math.max(end1, end2);
        }
        return wordsValue;
    }

    private void mergeWord(List<WordsValue> myDyList) {
        int i;
        for (i = 0; i < myDyList.size(); ++i) {
            WordsValue dynamicState = myDyList.get(i);
            if (dynamicState.isMerge) continue;
            for (int j = 0; j < myDyList.size(); ++j) {
                if (j == i) continue;
                int startIndex = dynamicState.startIndex;
                int endIndex = dynamicState.endIndex;
                boolean isFinish = dynamicState.isFinish;
                String word = dynamicState.word;
                float value = dynamicState.value;
                WordsValue dynamic = myDyList.get(j);
                int myStart = dynamic.startIndex;
                int myEnd = dynamic.endIndex;
                WordsValue wordsValue = this.isContinuity(startIndex, endIndex, myStart, myEnd);
                if (wordsValue == null) continue;
                dynamic.isMerge = true;
                wordsValue.isFinish = isFinish || dynamic.isFinish;
                wordsValue.word = word.length() > dynamic.word.length() ? word : dynamic.word;
                wordsValue.value = wordsValue.isFinish ? this.maxFinishValue : Math.max(dynamic.value, value);
                dynamicState = wordsValue;
            }
            myDyList.set(i, dynamicState);
        }
        for (i = 0; i < myDyList.size(); ++i) {
            if (!myDyList.get((int)i).isMerge) continue;
            myDyList.remove(i);
            --i;
        }
    }

    private DynamicState getDynamicState(String myWord, List<DynamicState> dynamicStateList) {
        DynamicState myDy = null;
        int size = this.keyWords.size();
        int id = 0;
        for (int i = 0; i < size; ++i) {
            String keyWord = this.keyWords.get(i);
            if (keyWord.hashCode() != myWord.hashCode() || !keyWord.equals(myWord)) continue;
            id = i + 1;
            break;
        }
        if (id > 0) {
            for (DynamicState dynamicState : dynamicStateList) {
                if (dynamicState.getStateId()[0] != id) continue;
                myDy = dynamicState;
                break;
            }
        }
        return myDy;
    }

    private void creatID(String sentence, int startIndex, int endIndex) {
        List<DynamicState> dynamicStateList = this.dynamicProgramming.getDynamicStateList();
        int size = sentence.length();
        for (int i = 0; i < size; ++i) {
            DynamicState finish;
            DynamicState dynamicState;
            int id;
            String word;
            int k;
            if (i < startIndex) {
                for (k = 1; k <= startIndex - i; ++k) {
                    word = sentence.substring(i, i + k);
                    id = this.getID(word);
                    if (id > 0) {
                        dynamicState = new DynamicState(new int[]{id});
                        if (i + k == startIndex) {
                            dynamicState.setFinish(true);
                            dynamicState.setValue(this.maxFinishValue);
                            this.finishWords.add(word);
                        }
                        dynamicStateList.add(dynamicState);
                        continue;
                    }
                    if (i + k != startIndex) continue;
                    finish = this.getDynamicState(word, dynamicStateList);
                    finish.setFinish(true);
                    finish.setValue(this.maxFinishValue);
                }
                continue;
            }
            if (i <= endIndex) continue;
            for (k = 1; k <= size - i; ++k) {
                word = sentence.substring(i, i + k);
                id = this.getID(word);
                if (id > 0) {
                    dynamicState = new DynamicState(new int[]{id});
                    if (i == endIndex + 1) {
                        dynamicState.setFinish(true);
                        dynamicState.setValue(this.maxFinishValue);
                        this.finishWords.add(word);
                    }
                    dynamicStateList.add(dynamicState);
                    continue;
                }
                if (i != endIndex + 1) continue;
                finish = this.getDynamicState(word, dynamicStateList);
                finish.setFinish(true);
                finish.setValue(this.maxFinishValue);
            }
        }
    }

    private int getID(String word) {
        int id = 0;
        boolean isHere = false;
        for (String myWord : this.keyWords) {
            if (myWord.hashCode() != word.hashCode() || !myWord.equals(word)) continue;
            isHere = true;
            break;
        }
        if (!isHere) {
            this.keyWords.add(word);
            id = this.keyWords.size();
        }
        return id;
    }

    static class WordsValue {
        int id;
        int startIndex;
        int endIndex;
        float value = 0.0f;
        boolean isFinish;
        String word;
        boolean isMerge = false;

        WordsValue() {
        }
    }
}

