/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.nerveCenter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dromara.easyai.conv.ConvCount;
import org.dromara.easyai.i.ActiveFunction;
import org.dromara.easyai.matrixTools.Matrix;
import org.dromara.easyai.nerveCenter.ModelParameter;
import org.dromara.easyai.nerveEntity.ConvDymNerveStudy;
import org.dromara.easyai.nerveEntity.ConvParameter;
import org.dromara.easyai.nerveEntity.DymNerveStudy;
import org.dromara.easyai.nerveEntity.HiddenNerve;
import org.dromara.easyai.nerveEntity.Nerve;
import org.dromara.easyai.nerveEntity.NerveStudy;
import org.dromara.easyai.nerveEntity.OutNerve;
import org.dromara.easyai.nerveEntity.SensoryNerve;
import org.dromara.easyai.nerveEntity.SoftMax;

public class NerveManager
extends ConvCount {
    private final int hiddenNerveNub;
    private final int sensoryNerveNub;
    private final int outNerveNub;
    private final int hiddenDepth;
    private final List<SensoryNerve> sensoryNerves = new ArrayList<SensoryNerve>();
    private SensoryNerve convInput;
    private final List<List<Nerve>> depthNerves = new ArrayList<List<Nerve>>();
    private List<Nerve> convDepthNerves = new ArrayList<Nerve>();
    private final List<Nerve> outNerves = new ArrayList<Nerve>();
    private final List<Nerve> softMaxList = new ArrayList<Nerve>();
    private boolean initPower;
    private float studyPoint = 0.001f;
    private float convStudyPoint = 0.001f;
    private float oneConvRate = 0.001f;
    private final ActiveFunction activeFunction;
    private final int rzType;
    private final float lParam;
    private final int coreNumber;

    public SensoryNerve getConvInput() {
        return this.convInput;
    }

    private Map<String, Float> conversion(Map<Integer, Float> map) {
        HashMap<String, Float> cMap = new HashMap<String, Float>();
        for (Map.Entry<Integer, Float> entry : map.entrySet()) {
            cMap.put(String.valueOf(entry.getKey()), entry.getValue());
        }
        return cMap;
    }

    private Map<Integer, Float> unConversion(Map<String, Float> map) {
        HashMap<Integer, Float> cMap = new HashMap<Integer, Float>();
        for (Map.Entry<String, Float> entry : map.entrySet()) {
            cMap.put(Integer.parseInt(entry.getKey()), entry.getValue());
        }
        return cMap;
    }

    private ModelParameter getDymModelParameter() throws Exception {
        ModelParameter modelParameter = new ModelParameter();
        ArrayList<ConvDymNerveStudy> convStudies = new ArrayList<ConvDymNerveStudy>();
        modelParameter.setDymNerveStudies(convStudies);
        for (Nerve convDepthNerve : this.convDepthNerves) {
            ConvParameter convParameter = convDepthNerve.getConvParameter();
            List<Matrix> nerveMatrixList = convParameter.getNerveMatrixList();
            ConvDymNerveStudy convDymNerveStudy = new ConvDymNerveStudy();
            List<List<Float>> oneConvList = convParameter.getOneConvPower();
            ArrayList<DymNerveStudy> dymNerveStudies = new ArrayList<DymNerveStudy>();
            convDymNerveStudy.setOneConvPower(oneConvList);
            convDymNerveStudy.setDymNerveStudyList(dymNerveStudies);
            for (Matrix nerveMatrix : nerveMatrixList) {
                DymNerveStudy deepNerveStudy = new DymNerveStudy();
                List<Float> list = deepNerveStudy.getList();
                this.insertWList(nerveMatrix, list);
                dymNerveStudies.add(deepNerveStudy);
            }
            convStudies.add(convDymNerveStudy);
        }
        this.getStaticModelParameter(modelParameter);
        return modelParameter;
    }

    private void insertWList(Matrix matrix, List<Float> list) throws Exception {
        for (int i = 0; i < matrix.getX(); ++i) {
            for (int j = 0; j < matrix.getY(); ++j) {
                list.add(Float.valueOf(matrix.getNumber(i, j)));
            }
        }
    }

    public ModelParameter getConvModel() throws Exception {
        return this.getDymModelParameter();
    }

    public ModelParameter getDnnModel() throws Exception {
        ModelParameter modelParameter = new ModelParameter();
        this.getStaticModelParameter(modelParameter);
        return modelParameter;
    }

    private void getStaticModelParameter(ModelParameter modelParameter) {
        ArrayList<List<NerveStudy>> studyDepthNerves = new ArrayList<List<NerveStudy>>();
        ArrayList<NerveStudy> outStudyNerves = new ArrayList<NerveStudy>();
        for (List<Nerve> depthNerve : this.depthNerves) {
            ArrayList<NerveStudy> deepNerve = new ArrayList<NerveStudy>();
            for (Nerve nerve : depthNerve) {
                NerveStudy nerveStudy = new NerveStudy();
                nerveStudy.setThreshold(nerve.getThreshold());
                nerveStudy.setDendrites(this.conversion(nerve.getDendrites()));
                deepNerve.add(nerveStudy);
            }
            studyDepthNerves.add(deepNerve);
        }
        for (Nerve nerve : this.outNerves) {
            NerveStudy nerveStudy = new NerveStudy();
            nerveStudy.setThreshold(nerve.getThreshold());
            nerveStudy.setDendrites(this.conversion(nerve.getDendrites()));
            outStudyNerves.add(nerveStudy);
        }
        modelParameter.setDepthNerves(studyDepthNerves);
        modelParameter.setOutNerves(outStudyNerves);
    }

    public void insertConvModel(ModelParameter modelParameter) throws Exception {
        this.insertConvolutionModelParameter(modelParameter);
    }

    public void insertDnnModel(ModelParameter modelParameter) {
        this.insertBpModelParameter(modelParameter);
    }

    private void insertConvolutionModelParameter(ModelParameter modelParameter) throws Exception {
        List<ConvDymNerveStudy> allDymNerveStudyList = modelParameter.getDymNerveStudies();
        for (int t = 0; t < allDymNerveStudyList.size(); ++t) {
            List<DymNerveStudy> dymNerveStudyList;
            ConvParameter convParameter = this.convDepthNerves.get(t).getConvParameter();
            List<Matrix> nerveMatrixList = convParameter.getNerveMatrixList();
            ConvDymNerveStudy convDymNerveStudy = allDymNerveStudyList.get(t);
            List<List<Float>> oneConvPower = convDymNerveStudy.getOneConvPower();
            if (oneConvPower != null && !oneConvPower.isEmpty()) {
                convParameter.setOneConvPower(oneConvPower);
            }
            if ((dymNerveStudyList = convDymNerveStudy.getDymNerveStudyList()).size() != nerveMatrixList.size()) {
                throw new Exception("\u5377\u79ef\u5c42\u6570\u91cf\u53c2\u6570\u4e0e\u6a21\u578b\u4e0d\u5339\u914d");
            }
            for (int i = 0; i < dymNerveStudyList.size(); ++i) {
                List<Float> list = dymNerveStudyList.get(i).getList();
                Matrix nerveMatrix = nerveMatrixList.get(i);
                this.insertMatrix(nerveMatrix, list);
            }
        }
        this.insertBpModelParameter(modelParameter);
    }

    private void insertMatrix(Matrix matrix, List<Float> list) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            matrix.setNub(i, 0, list.get(i).floatValue());
        }
    }

    private void insertBpModelParameter(ModelParameter modelParameter) {
        int i;
        List<List<NerveStudy>> depthStudyNerves = modelParameter.getDepthNerves();
        List<NerveStudy> outStudyNerves = modelParameter.getOutNerves();
        for (i = 0; i < this.depthNerves.size(); ++i) {
            List<NerveStudy> depth = depthStudyNerves.get(i);
            List<Nerve> depthNerve = this.depthNerves.get(i);
            for (int j = 0; j < depthNerve.size(); ++j) {
                Nerve nerve = depthNerve.get(j);
                NerveStudy nerveStudy = depth.get(j);
                Map<Integer, Float> studyDendrites = this.unConversion(nerveStudy.getDendrites());
                Map<Integer, Float> dendrites = nerve.getDendrites();
                nerve.setThreshold(nerveStudy.getThreshold());
                for (Map.Entry<Integer, Float> entry : dendrites.entrySet()) {
                    int key = entry.getKey();
                    dendrites.put(key, studyDendrites.get(key));
                }
            }
        }
        for (i = 0; i < this.outNerves.size(); ++i) {
            Nerve outNerve = this.outNerves.get(i);
            NerveStudy nerveStudy = outStudyNerves.get(i);
            outNerve.setThreshold(nerveStudy.getThreshold());
            Map<Integer, Float> dendrites = outNerve.getDendrites();
            Map<Integer, Float> studyDendrites = this.unConversion(nerveStudy.getDendrites());
            for (Map.Entry<Integer, Float> outEntry : dendrites.entrySet()) {
                int key = outEntry.getKey();
                dendrites.put(key, studyDendrites.get(key));
            }
        }
    }

    public NerveManager(int sensoryNerveNub, int hiddenNerveNub, int outNerveNub, int hiddenDepth, ActiveFunction activeFunction, float studyPoint, int rzType, float lParam, int coreNumber) throws Exception {
        if (sensoryNerveNub > 0 && hiddenNerveNub > 0 && outNerveNub > 0 && hiddenDepth > 0 && activeFunction != null) {
            this.coreNumber = coreNumber;
            this.hiddenNerveNub = hiddenNerveNub;
            this.sensoryNerveNub = sensoryNerveNub;
            this.outNerveNub = outNerveNub;
            this.hiddenDepth = hiddenDepth;
            this.activeFunction = activeFunction;
            this.rzType = rzType;
            this.lParam = lParam;
            if (studyPoint > 0.0f && studyPoint < 1.0f) {
                this.studyPoint = studyPoint;
            }
        } else {
            throw new Exception("param is null");
        }
    }

    public List<SensoryNerve> getSensoryNerves() {
        return this.sensoryNerves;
    }

    private List<Nerve> initConDepthNerve(int kernLen, int conHiddenDepth, ActiveFunction convFunction, int channelNo, boolean norm) throws Exception {
        int i;
        ArrayList<Nerve> depthNerves = new ArrayList<Nerve>();
        for (i = 0; i < conHiddenDepth; ++i) {
            float studyPoint = this.convStudyPoint;
            if (studyPoint <= 0.0f || studyPoint > 1.0f) {
                throw new Exception("studyPoint Values range from 0 to 1");
            }
            int downNub = 1;
            boolean isConvFinish = false;
            if (i == conHiddenDepth - 1) {
                downNub = this.hiddenNerveNub;
                isConvFinish = true;
            }
            HiddenNerve hiddenNerve = new HiddenNerve(1, i + 1, 1, downNub, studyPoint, this.initPower, convFunction, true, this.rzType, this.lParam, kernLen, 0, 0, isConvFinish, this.coreNumber, channelNo, this.oneConvRate, norm);
            depthNerves.add(hiddenNerve);
        }
        for (i = 0; i < conHiddenDepth - 1; ++i) {
            Nerve hiddenNerve = (Nerve)depthNerves.get(i);
            Nerve nextHiddenNerve = (Nerve)depthNerves.get(i + 1);
            hiddenNerve.connectSonOnly(nextHiddenNerve);
            nextHiddenNerve.connectFatherOnly(hiddenNerve);
        }
        return depthNerves;
    }

    private int getNerveNub(int deep, int size, int kernLen) {
        int x = size;
        int step = 1;
        for (int i = 0; i < deep; ++i) {
            x = (x - (kernLen - step)) / step;
            x = x / 2 + x % 2;
        }
        return x;
    }

    public void initImageNet(int channelNo, int kernLen, int xSize, int ySize, boolean isSoftMax, boolean isShowLog, float convStudyPoint, ActiveFunction convFunction, int minFeatureValue, float oneConvRate, boolean norm) throws Exception {
        this.initPower = true;
        this.oneConvRate = oneConvRate;
        if (minFeatureValue < 1 || minFeatureValue > 50) {
            throw new Exception("minFeatureValue \u53d6\u503c\u8303\u56f4\u662f[1,50]");
        }
        if (channelNo < 1) {
            throw new Exception("\u901a\u9053\u6570\u4e0d\u80fd\u5c0f\u4e8e1");
        }
        if (!norm) {
            channelNo = 3;
        }
        this.convStudyPoint = convStudyPoint;
        int deep = this.getConvMyDep(xSize, ySize, kernLen, minFeatureValue);
        if (deep < 2) {
            throw new Exception("minFeatureValue \u8bbe\u7f6e\u8fc7\u5927");
        }
        List<Nerve> myDepthNerves = this.initConDepthNerve(kernLen, deep, convFunction, channelNo, norm);
        Nerve convFirstNerve = myDepthNerves.get(0);
        Nerve convLastNerve = myDepthNerves.get(myDepthNerves.size() - 1);
        this.convDepthNerves = myDepthNerves;
        this.convInput = new SensoryNerve(1, 0, channelNo);
        this.convInput.connectSonOnly(convFirstNerve);
        this.initDepthNerve(kernLen, this.getNerveNub(deep, xSize, kernLen), this.getNerveNub(deep, ySize, kernLen), channelNo);
        List<Nerve> firstNerves = this.depthNerves.get(0);
        List<Nerve> lastNerveList = this.depthNerves.get(this.depthNerves.size() - 1);
        convLastNerve.connect(firstNerves);
        for (Nerve nerve : firstNerves) {
            nerve.connectFatherOnly(convLastNerve);
        }
        ArrayList<OutNerve> myOutNerveList = new ArrayList<OutNerve>();
        for (int i = 1; i < this.outNerveNub + 1; ++i) {
            OutNerve outNerve = new OutNerve(i, this.hiddenNerveNub, 0, this.studyPoint, this.initPower, this.activeFunction, false, isShowLog, this.rzType, this.lParam, isSoftMax, 0, this.coreNumber);
            outNerve.connectFather(lastNerveList);
            this.outNerves.add(outNerve);
            myOutNerveList.add(outNerve);
        }
        if (isSoftMax) {
            SoftMax softMax = new SoftMax(this.outNerveNub, false, myOutNerveList, isShowLog, this.coreNumber);
            this.softMaxList.add(softMax);
            for (Nerve nerve : this.outNerves) {
                nerve.connect(this.softMaxList);
            }
        }
        for (Nerve nerve : lastNerveList) {
            nerve.connect(this.outNerves);
        }
    }

    public void init(boolean initPower, boolean isShowLog, boolean isSoftMax) throws Exception {
        this.initPower = initPower;
        this.initDepthNerve(0, 0, 0, 0);
        List<Nerve> nerveList = this.depthNerves.get(0);
        List<Nerve> lastNerveList = this.depthNerves.get(this.depthNerves.size() - 1);
        ArrayList<OutNerve> myOutNerveList = new ArrayList<OutNerve>();
        for (int i = 1; i < this.outNerveNub + 1; ++i) {
            OutNerve outNerve = new OutNerve(i, this.hiddenNerveNub, 0, this.studyPoint, initPower, this.activeFunction, false, isShowLog, this.rzType, this.lParam, isSoftMax, 0, this.coreNumber);
            outNerve.connectFather(lastNerveList);
            this.outNerves.add(outNerve);
            myOutNerveList.add(outNerve);
        }
        if (isSoftMax) {
            SoftMax softMax = new SoftMax(this.outNerveNub, false, myOutNerveList, isShowLog, this.coreNumber);
            this.softMaxList.add(softMax);
            for (Nerve nerve : this.outNerves) {
                nerve.connect(this.softMaxList);
            }
        }
        for (Nerve nerve : lastNerveList) {
            nerve.connect(this.outNerves);
        }
        for (int i = 1; i < this.sensoryNerveNub + 1; ++i) {
            SensoryNerve sensoryNerve = new SensoryNerve(i, 0, 0);
            sensoryNerve.connect(nerveList);
            this.sensoryNerves.add(sensoryNerve);
        }
    }

    private void initDepthNerve(int kernLen, int matrixX, int matrixY, int channelNo) throws Exception {
        for (int i = 0; i < this.hiddenDepth; ++i) {
            ArrayList<HiddenNerve> hiddenNerveList = new ArrayList<HiddenNerve>();
            float studyPoint = this.studyPoint;
            if (studyPoint <= 0.0f || studyPoint > 1.0f) {
                throw new Exception("studyPoint Values range from 0 to 1");
            }
            for (int j = 1; j < this.hiddenNerveNub + 1; ++j) {
                int upNub;
                int myMatrixX = 0;
                int myMatrixY = 0;
                if (i == 0) {
                    myMatrixX = matrixX;
                    myMatrixY = matrixY;
                    upNub = matrixX > 0 && matrixY > 0 ? matrixX * matrixY * channelNo : this.sensoryNerveNub;
                } else {
                    upNub = this.hiddenNerveNub;
                }
                int downNub = i == this.hiddenDepth - 1 ? this.outNerveNub : this.hiddenNerveNub;
                HiddenNerve hiddenNerve = new HiddenNerve(j, i + 1, upNub, downNub, studyPoint, this.initPower, this.activeFunction, false, this.rzType, this.lParam, kernLen, myMatrixX, myMatrixY, false, this.coreNumber, 0, this.oneConvRate, false);
                hiddenNerveList.add(hiddenNerve);
            }
            this.depthNerves.add(hiddenNerveList);
        }
        this.initHiddenNerve();
    }

    private void initHiddenNerve() {
        for (int i = 0; i < this.hiddenDepth - 1; ++i) {
            List<Nerve> hiddenNerveList = this.depthNerves.get(i);
            List<Nerve> nextHiddenNerveList = this.depthNerves.get(i + 1);
            for (Nerve hiddenNerve : hiddenNerveList) {
                hiddenNerve.connect(nextHiddenNerveList);
            }
            for (Nerve nextHiddenNerve : nextHiddenNerveList) {
                nextHiddenNerve.connectFather(hiddenNerveList);
            }
        }
    }
}

