/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.nerveEntity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dromara.easyai.entity.ThreeChannelMatrix;
import org.dromara.easyai.i.ActiveFunction;
import org.dromara.easyai.i.OutBack;
import org.dromara.easyai.matrixTools.Matrix;
import org.dromara.easyai.matrixTools.MatrixList;
import org.dromara.easyai.matrixTools.MatrixOperation;
import org.dromara.easyai.nerveEntity.Nerve;

public class HiddenNerve
extends Nerve {
    private final boolean isConvFinish;
    private final MatrixOperation matrixOperation = new MatrixOperation();

    public HiddenNerve(int id, int depth, int upNub, int downNub, float studyPoint, boolean init, ActiveFunction activeFunction, boolean isDynamic, int rzType, float lParam, int kernLen, int matrixX, int matrixY, boolean isConvFinish, int coreNumber, int channelNo, float oneConvStudy, boolean norm) throws Exception {
        super(id, upNub, "HiddenNerve", downNub, studyPoint, init, activeFunction, isDynamic, rzType, lParam, kernLen, depth, matrixX, matrixY, coreNumber, channelNo, oneConvStudy, norm);
        this.isConvFinish = isConvFinish;
    }

    @Override
    public void input(long eventId, float parameter, boolean isKernelStudy, Map<Integer, Float> E, OutBack outBack) throws Exception {
        boolean allReady = this.insertParameter(eventId, parameter);
        if (allReady) {
            float sigma = this.calculation(eventId);
            float out = this.activeFunction.function(sigma);
            if (isKernelStudy) {
                this.outNub = out;
            } else {
                this.destoryParameter(eventId);
            }
            this.sendMessage(eventId, out, isKernelStudy, E, outBack);
        }
    }

    @Override
    protected void inputMatrixFeature(long eventId, List<Float> parameters, boolean isStudy, Map<Integer, Float> E, OutBack imageBack) throws Exception {
        this.insertParameters(eventId, parameters);
        float sigma = this.calculation(eventId);
        float out = this.activeFunction.function(sigma);
        if (isStudy) {
            this.outNub = out;
        } else {
            this.destoryParameter(eventId);
        }
        this.sendMessage(eventId, out, isStudy, E, imageBack);
    }

    @Override
    protected void inputMatrix(long eventId, List<Matrix> matrix, boolean isStudy, Map<Integer, Float> E, OutBack outBack, boolean needMatrix) throws Exception {
        List<Matrix> myMatrix = this.conv(matrix);
        if (this.isConvFinish) {
            Matrix ourMatrix;
            if (myMatrix.size() == 1) {
                ourMatrix = myMatrix.get(0);
            } else {
                MatrixList matrixList = new MatrixList(myMatrix.get(0), true, 100);
                for (int i = 1; i < myMatrix.size(); ++i) {
                    matrixList.add(myMatrix.get(i));
                }
                ourMatrix = matrixList.getMatrix();
            }
            if (!isStudy && needMatrix) {
                outBack.getBackMatrix(ourMatrix, this.getId(), eventId);
            }
            this.sendMatrixList(eventId, this.matrixOperation.matrixToList(ourMatrix), isStudy, E, outBack);
        } else {
            this.sendMatrix(eventId, myMatrix, isStudy, E, outBack, needMatrix);
        }
    }

    @Override
    protected void inputThreeChannelMatrix(long eventId, ThreeChannelMatrix picture, boolean isKernelStudy, Map<Integer, Float> E, OutBack outBack, boolean needMatrix) throws Exception {
        ArrayList<Matrix> matrixList = new ArrayList<Matrix>();
        matrixList.add(picture.getMatrixR());
        matrixList.add(picture.getMatrixG());
        matrixList.add(picture.getMatrixB());
        this.demRedByMatrixList(eventId, matrixList, isKernelStudy, E, outBack, needMatrix);
    }
}

