/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.pso;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.dromara.easyai.i.PsoFunction;

public class PSO {
    private float globalValue = -1.0f;
    private int times;
    private List<Particle> allPar = new ArrayList<Particle>();
    private PsoFunction psoFunction;
    private float inertialFactor = 0.5f;
    private float selfStudyFactor = 2.0f;
    private float socialStudyFactor = 2.0f;
    private boolean isMax;
    private float[] allBest;
    private Random random = new Random();
    private float[] minBorder;
    private float[] maxBorder;
    private float maxSpeed;
    private float initSpeed;

    public PSO(int dimensionNub, float[] minBorder, float[] maxBorder, int times, int particleNub, PsoFunction psoFunction, float inertialFactor, float selfStudyFactor, float socialStudyFactor, boolean isMax, float maxSpeed, float initSpeed) {
        this.initSpeed = initSpeed;
        this.times = times;
        this.psoFunction = psoFunction;
        this.isMax = isMax;
        this.allBest = new float[dimensionNub];
        this.minBorder = minBorder;
        this.maxBorder = maxBorder;
        this.maxSpeed = maxSpeed;
        if (inertialFactor > 0.0f) {
            this.inertialFactor = inertialFactor;
        }
        if (selfStudyFactor >= 0.0f && selfStudyFactor <= 4.0f) {
            this.selfStudyFactor = selfStudyFactor;
        }
        if (socialStudyFactor >= 0.0f && socialStudyFactor <= 4.0f) {
            this.socialStudyFactor = socialStudyFactor;
        }
        for (int i = 0; i < particleNub; ++i) {
            Particle particle = new Particle(dimensionNub);
            this.allPar.add(particle);
        }
    }

    public float[] getAllBest() {
        return this.allBest;
    }

    public void setAllPar(List<Particle> allPar) {
        this.allPar = allPar;
    }

    public void start() throws Exception {
        int size = this.allPar.size();
        for (int i = 0; i < this.times; ++i) {
            for (int j = 0; j < size; ++j) {
                this.move(this.allPar.get(j), j);
            }
        }
    }

    private void move(Particle particle, int id) throws Exception {
        int i;
        float[] parameter = particle.getParameter();
        BestData[] bestData = particle.bestDataArray;
        float value = this.psoFunction.getResult(parameter, id);
        float selfValue = particle.selfBestValue;
        if (this.isMax) {
            if (value > this.globalValue) {
                this.globalValue = value;
                for (i = 0; i < this.allBest.length; ++i) {
                    this.allBest[i] = parameter[i];
                }
            }
            if (value > selfValue) {
                particle.selfBestValue = value;
                for (i = 0; i < bestData.length; ++i) {
                    bestData[i].selfBestPosition = parameter[i];
                }
            }
        } else {
            if (this.globalValue < 0.0f || value < this.globalValue) {
                this.globalValue = value;
                for (i = 0; i < this.allBest.length; ++i) {
                    this.allBest[i] = parameter[i];
                }
            }
            if (selfValue < 0.0f || value < selfValue) {
                particle.selfBestValue = value;
                for (i = 0; i < bestData.length; ++i) {
                    bestData[i].selfBestPosition = parameter[i];
                }
            }
        }
        for (i = 0; i < bestData.length; ++i) {
            float speed = bestData[i].speed;
            float pid = bestData[i].selfBestPosition;
            float selfPosition = parameter[i];
            float pgd = this.allBest[i];
            if (Math.abs(speed = this.inertialFactor * speed + this.selfStudyFactor * this.random.nextFloat() * (pid - selfPosition) + this.socialStudyFactor * this.random.nextFloat() * (pgd - selfPosition)) > this.maxSpeed) {
                speed = speed > 0.0f ? this.maxSpeed : -this.maxSpeed;
            }
            bestData[i].speed = speed;
            float position = selfPosition + speed;
            if (this.minBorder != null) {
                if (position < this.minBorder[i]) {
                    position = this.minBorder[i];
                }
                if (position > this.maxBorder[i]) {
                    position = this.maxBorder[i];
                }
            }
            bestData[i].selfPosition = position;
        }
    }

    class Particle {
        private BestData[] bestDataArray;
        private float selfBestValue = -1.0f;

        private float[] getParameter() {
            float[] parameter = new float[this.bestDataArray.length];
            for (int i = 0; i < parameter.length; ++i) {
                parameter[i] = this.bestDataArray[i].selfPosition;
            }
            return parameter;
        }

        protected Particle(int dimensionNub) {
            this.bestDataArray = new BestData[dimensionNub];
            for (int i = 0; i < dimensionNub; ++i) {
                float position;
                if (PSO.this.minBorder != null && PSO.this.maxBorder != null) {
                    float min = PSO.this.minBorder[i];
                    float max = PSO.this.maxBorder[i];
                    float region = max - min + 1.0f;
                    position = (float)PSO.this.random.nextInt((int)region) + min;
                } else {
                    position = PSO.this.random.nextFloat();
                }
                this.bestDataArray[i] = new BestData(position, PSO.this.initSpeed);
            }
        }
    }

    class BestData {
        private float speed;
        private float selfBestPosition;
        private float selfPosition;

        private BestData(float selfPosition, float initSpeed) {
            this.selfBestPosition = selfPosition;
            this.selfPosition = selfPosition;
            this.speed = initSpeed;
        }
    }
}

