/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.regressionForest;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.dromara.easyai.matrixTools.Matrix;
import org.dromara.easyai.matrixTools.MatrixOperation;
import org.dromara.easyai.regressionForest.Forest;
import org.dromara.easyai.tools.Frequency;

public class RegressionForest
extends Frequency {
    private float[] w;
    private Matrix conditionMatrix;
    private Matrix resultMatrix;
    private Forest forest;
    private int featureNub;
    private int xIndex = 0;
    private float[] results;
    private float min;
    private float max;
    private Matrix pc;
    private int cosSize = 20;
    private TreeMap<Integer, Forest> forestMap = new TreeMap();
    private final MatrixOperation matrixOperation = new MatrixOperation();

    public int getCosSize() {
        return this.cosSize;
    }

    public void setCosSize(int cosSize) {
        this.cosSize = cosSize;
    }

    public RegressionForest(int size, int featureNub, float shrinkParameter, int minGrain) throws Exception {
        if (size <= 0 || featureNub <= 0) {
            throw new Exception("size and featureNub too small");
        }
        this.featureNub = featureNub;
        this.w = new float[featureNub];
        this.results = new float[size];
        this.conditionMatrix = new Matrix(size, featureNub);
        this.resultMatrix = new Matrix(size, 1);
        this.createG();
        this.forest = new Forest(featureNub, shrinkParameter, this.pc, this.forestMap, 1, minGrain);
        this.forestMap.put(1, this.forest);
        this.forest.setW(this.w);
        this.forest.setConditionMatrix(this.conditionMatrix);
        this.forest.setResultMatrix(this.resultMatrix);
    }

    public float getDist(Matrix featureMatrix, float result) throws Exception {
        Forest forestFinish = this.getRegion(this.forest, featureMatrix);
        float[] w = forestFinish.getW();
        float sigma = 0.0f;
        for (int i = 0; i < w.length; ++i) {
            float nub = i < w.length - 1 ? w[i] * featureMatrix.getNumber(0, i) : w[i];
            sigma += nub;
        }
        return Math.abs(result - sigma);
    }

    private Forest getRegion(Forest forest, Matrix matrix) throws Exception {
        float median = forest.getMedian();
        float result = forest.getMappingFeature(matrix);
        if (result > median && forest.getForestRight() != null) {
            forest = forest.getForestRight();
        } else if (result <= median && forest.getForestLeft() != null) {
            forest = forest.getForestLeft();
        } else {
            return forest;
        }
        return this.getRegion(forest, matrix);
    }

    private Forest getLimitRegion(Forest forest, boolean isMax) {
        Forest forestSon = isMax ? forest.getForestRight() : forest.getForestLeft();
        if (forestSon != null) {
            return this.getLimitRegion(forestSon, isMax);
        }
        return forest;
    }

    private void createG() throws Exception {
        float[] cg = new float[this.featureNub - 1];
        Random random = new Random();
        float sigma = 0.0f;
        for (int i = 0; i < this.featureNub - 1; ++i) {
            float rm;
            cg[i] = rm = random.nextFloat();
            sigma += (float)Math.pow(rm, 2.0);
        }
        float cosOne = 1.0f / (float)this.cosSize;
        float[] ag = new float[this.cosSize - 1];
        for (int i = 0; i < this.cosSize - 1; ++i) {
            float cos = cosOne * (float)(i + 1);
            ag[i] = (float)Math.sqrt(sigma / (1.0f / (float)Math.pow(cos, 2.0) - 1.0f));
        }
        int x = (this.cosSize - 1) * this.featureNub;
        this.pc = new Matrix(x, this.featureNub);
        for (int i = 0; i < this.featureNub; ++i) {
            Matrix matrix = new Matrix(ag.length, this.featureNub);
            for (int j = 0; j < ag.length; ++j) {
                for (int k = 0; k < this.featureNub; ++k) {
                    if (k != i) {
                        if (k < i) {
                            matrix.setNub(j, k, cg[k]);
                            continue;
                        }
                        matrix.setNub(j, k, cg[k - 1]);
                        continue;
                    }
                    matrix.setNub(j, k, ag[j]);
                }
            }
            int index = (this.cosSize - 1) * i;
            this.push(this.pc, matrix, index);
        }
    }

    private void push(Matrix mother, Matrix son, int index) throws Exception {
        if (mother.getY() == son.getY()) {
            int x = index + son.getX();
            int y = mother.getY();
            int start = 0;
            for (int i = index; i < x; ++i) {
                for (int j = 0; j < y; ++j) {
                    mother.setNub(i, j, son.getNumber(start, j));
                }
                ++start;
            }
        } else {
            throw new Exception("matrix Y is not equals");
        }
    }

    public void insertFeature(float[] feature, float result) throws Exception {
        if (feature.length == this.featureNub - 1) {
            for (int i = 0; i < this.featureNub; ++i) {
                if (i < this.featureNub - 1) {
                    this.conditionMatrix.setNub(this.xIndex, i, feature[i]);
                    continue;
                }
                this.results[this.xIndex] = result;
                this.conditionMatrix.setNub(this.xIndex, i, 1.0f);
                this.resultMatrix.setNub(this.xIndex, 0, result);
            }
            ++this.xIndex;
        } else {
            throw new Exception("feature length is not equals");
        }
    }

    public void startStudy() throws Exception {
        if (this.forest == null) {
            throw new Exception("rootForest is null");
        }
        this.forest.setResultVariance(this.variance(this.results));
        float[] limit = this.getLimit(this.results);
        this.min = limit[0];
        this.max = limit[1];
        this.start(this.forest);
        this.regression();
        this.pruning();
    }

    private void start(Forest forest) throws Exception {
        forest.cut();
        Forest forestLeft = forest.getForestLeft();
        Forest forestRight = forest.getForestRight();
        if (forestLeft != null && forestRight != null) {
            this.start(forestLeft);
            this.start(forestRight);
        }
    }

    private void pruning() {
        int max = this.forestMap.lastKey();
        int layersNub = (int)((float)Math.log(max) / (float)Math.log(2.0));
        int lastMin = (int)Math.pow(2.0, layersNub);
        if (layersNub > 1) {
            for (Map.Entry<Integer, Forest> entry : this.forestMap.entrySet()) {
                if (entry.getKey() < lastMin) continue;
                Forest forest = entry.getValue();
                forest.pruning();
            }
        }
        block1: for (int i = layersNub - 1; i > 0; --i) {
            int min = (int)Math.pow(2.0, i);
            int maxNub = (int)Math.pow(2.0, i + 1);
            for (Map.Entry<Integer, Forest> entry : this.forestMap.entrySet()) {
                int key = entry.getKey();
                if (key >= min && key < maxNub) {
                    entry.getValue().pruning();
                    continue;
                }
                if (key < maxNub) continue;
                continue block1;
            }
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Map.Entry<Integer, Forest> entry : this.forestMap.entrySet()) {
            int key = entry.getKey();
            Forest forest = entry.getValue();
            if (!forest.isRemove()) continue;
            list.add(key);
        }
        Iterator<Map.Entry<Integer, Forest>> iterator = list.iterator();
        while (iterator.hasNext()) {
            int key = (Integer)((Object)iterator.next());
            this.forestMap.remove(key);
        }
    }

    private void regression() throws Exception {
        if (this.forest == null) {
            throw new Exception("rootForest is null");
        }
        this.regressionTree(this.forest);
    }

    private void regressionTree(Forest forest) throws Exception {
        this.regression(forest);
        Forest forestLeft = forest.getForestLeft();
        Forest forestRight = forest.getForestRight();
        if (forestLeft != null && forestRight != null) {
            this.regressionTree(forestLeft);
            this.regressionTree(forestRight);
        }
    }

    private void regression(Forest forest) throws Exception {
        Matrix conditionMatrix = forest.getConditionMatrix();
        Matrix resultMatrix = forest.getResultMatrix();
        Matrix ws = this.matrixOperation.getLinearRegression(conditionMatrix, resultMatrix);
        float[] w = forest.getW();
        for (int i = 0; i < ws.getX(); ++i) {
            w[i] = ws.getNumber(i, 0);
        }
    }
}

