/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.rnnJumpNerveCenter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dromara.easyai.i.ActiveFunction;
import org.dromara.easyai.matrixTools.Matrix;
import org.dromara.easyai.rnnJumpNerveCenter.ModelParameter;
import org.dromara.easyai.rnnJumpNerveCenter.RnnOutNerveStudy;
import org.dromara.easyai.rnnJumpNerveEntity.DymNerveStudy;
import org.dromara.easyai.rnnJumpNerveEntity.HiddenNerve;
import org.dromara.easyai.rnnJumpNerveEntity.Nerve;
import org.dromara.easyai.rnnJumpNerveEntity.NerveCenter;
import org.dromara.easyai.rnnJumpNerveEntity.NerveStudy;
import org.dromara.easyai.rnnJumpNerveEntity.OutNerve;
import org.dromara.easyai.rnnJumpNerveEntity.RnnOutNerveBody;
import org.dromara.easyai.rnnJumpNerveEntity.SensoryNerve;
import org.dromara.easyai.rnnJumpNerveEntity.SoftMax;

public class NerveJumpManager {
    private final int hiddenNerveNub;
    private final int sensoryNerveNub;
    private final int outNerveNub;
    private final int hiddenDepth;
    private final List<SensoryNerve> sensoryNerves = new ArrayList<SensoryNerve>();
    private final List<List<Nerve>> depthNerves = new ArrayList<List<Nerve>>();
    private final List<Nerve> outNerves = new ArrayList<Nerve>();
    private final List<Nerve> softMaxList = new ArrayList<Nerve>();
    private final List<RnnOutNerveBody> rnnOutNerveBodies = new ArrayList<RnnOutNerveBody>();
    private boolean initPower;
    private float studyPoint = 0.1f;
    private final ActiveFunction activeFunction;
    private final boolean isDynamic;
    private boolean isRnn = false;
    private final int rzType;
    private final float lParam;
    private final List<NerveCenter> nerveCenterList = new ArrayList<NerveCenter>();
    private float powerTh = 0.2f;

    public List<NerveCenter> getNerveCenterList() {
        return this.nerveCenterList;
    }

    public void setPowerTh(float powerTh) {
        this.powerTh = powerTh;
    }

    private Map<String, Float> conversion(Map<Integer, Float> map) {
        HashMap<String, Float> cMap = new HashMap<String, Float>();
        for (Map.Entry<Integer, Float> entry : map.entrySet()) {
            cMap.put(String.valueOf(entry.getKey()), entry.getValue());
        }
        return cMap;
    }

    private Map<Integer, Float> unConversion(Map<String, Float> map) {
        HashMap<Integer, Float> cMap = new HashMap<Integer, Float>();
        for (Map.Entry<String, Float> entry : map.entrySet()) {
            cMap.put(Integer.parseInt(entry.getKey()), entry.getValue());
        }
        return cMap;
    }

    private ModelParameter getDymModelParameter() throws Exception {
        ModelParameter modelParameter = new ModelParameter();
        ArrayList<DymNerveStudy> dymNerveStudies = new ArrayList<DymNerveStudy>();
        DymNerveStudy dymOutNerveStudy = new DymNerveStudy();
        modelParameter.setDymNerveStudies(dymNerveStudies);
        modelParameter.setDymOutNerveStudy(dymOutNerveStudy);
        for (List<Nerve> nerve : this.depthNerves) {
            Nerve depthNerve = nerve.get(0);
            DymNerveStudy deepNerveStudy = new DymNerveStudy();
            List<Float> list = deepNerveStudy.getList();
            Matrix matrix = depthNerve.getNerveMatrix();
            this.insertWList(matrix, list);
            dymNerveStudies.add(deepNerveStudy);
        }
        Nerve outNerve = this.outNerves.get(0);
        Matrix matrix = outNerve.getNerveMatrix();
        List<Float> list = dymOutNerveStudy.getList();
        this.insertWList(matrix, list);
        return modelParameter;
    }

    private void insertWList(Matrix matrix, List<Float> list) throws Exception {
        for (int i = 0; i < matrix.getX(); ++i) {
            for (int j = 0; j < matrix.getY(); ++j) {
                list.add(Float.valueOf(matrix.getNumber(i, j)));
            }
        }
    }

    public ModelParameter getModelParameter() throws Exception {
        if (this.isRnn) {
            return this.getRnnModelParameter();
        }
        if (this.isDynamic) {
            return this.getDymModelParameter();
        }
        return this.getStaticModelParameter();
    }

    private ModelParameter getRnnModelParameter() {
        ModelParameter modelParameter = new ModelParameter();
        ArrayList<List<NerveStudy>> studyDepthNerves = new ArrayList<List<NerveStudy>>();
        ArrayList<RnnOutNerveStudy> rnnOutNerveStudies = new ArrayList<RnnOutNerveStudy>();
        modelParameter.setDepthNerves(studyDepthNerves);
        modelParameter.setRnnOutNerveStudies(rnnOutNerveStudies);
        for (List<Nerve> depthNerve : this.depthNerves) {
            ArrayList<NerveStudy> deepNerve = new ArrayList<NerveStudy>();
            for (Nerve nerve : depthNerve) {
                NerveStudy nerveStudy = new NerveStudy();
                nerveStudy.setThreshold(nerve.getThreshold());
                nerveStudy.setDendrites(this.conversion(nerve.getDendrites()));
                deepNerve.add(nerveStudy);
            }
            studyDepthNerves.add(deepNerve);
        }
        for (RnnOutNerveBody rnnOutNerveBody : this.rnnOutNerveBodies) {
            ArrayList<NerveStudy> nerveStudies = new ArrayList<NerveStudy>();
            RnnOutNerveStudy rnnOutNerveStudy = new RnnOutNerveStudy();
            rnnOutNerveStudies.add(rnnOutNerveStudy);
            rnnOutNerveStudy.setDepth(rnnOutNerveBody.getDepth());
            rnnOutNerveStudy.setNerveStudies(nerveStudies);
            List<Nerve> outNerveList = rnnOutNerveBody.getOutNerves();
            this.getOutNerveModel(nerveStudies, outNerveList);
        }
        return modelParameter;
    }

    private void getOutNerveModel(List<NerveStudy> nerveStudies, List<Nerve> outNerveList) {
        for (Nerve nerve : outNerveList) {
            NerveStudy nerveStudy = new NerveStudy();
            nerveStudy.setThreshold(nerve.getThreshold());
            nerveStudy.setDendrites(this.conversion(nerve.getDendrites()));
            nerveStudies.add(nerveStudy);
        }
    }

    private ModelParameter getStaticModelParameter() {
        ModelParameter modelParameter = new ModelParameter();
        ArrayList<List<NerveStudy>> studyDepthNerves = new ArrayList<List<NerveStudy>>();
        ArrayList<NerveStudy> outStudyNerves = new ArrayList<NerveStudy>();
        for (List<Nerve> depthNerve : this.depthNerves) {
            ArrayList<NerveStudy> deepNerve = new ArrayList<NerveStudy>();
            this.getOutNerveModel(deepNerve, depthNerve);
            studyDepthNerves.add(deepNerve);
        }
        for (Nerve nerve : this.outNerves) {
            NerveStudy nerveStudy = new NerveStudy();
            nerveStudy.setThreshold(nerve.getThreshold());
            nerveStudy.setDendrites(this.conversion(nerve.getDendrites()));
            outStudyNerves.add(nerveStudy);
        }
        modelParameter.setDepthNerves(studyDepthNerves);
        modelParameter.setOutNerves(outStudyNerves);
        return modelParameter;
    }

    public void insertModelParameter(ModelParameter modelParameter) throws Exception {
        if (this.isRnn) {
            this.insertRnnModelParameter(modelParameter);
        } else if (this.isDynamic) {
            this.insertConvolutionModelParameter(modelParameter);
        } else {
            this.insertBpModelParameter(modelParameter);
        }
    }

    private void insertConvolutionModelParameter(ModelParameter modelParameter) throws Exception {
        List<DymNerveStudy> dymNerveStudyList = modelParameter.getDymNerveStudies();
        DymNerveStudy dymOutNerveStudy = modelParameter.getDymOutNerveStudy();
        for (int i = 0; i < this.depthNerves.size(); ++i) {
            Nerve depthNerve = this.depthNerves.get(i).get(0);
            DymNerveStudy dymNerveStudy = dymNerveStudyList.get(i);
            List<Float> list = dymNerveStudy.getList();
            Matrix nerveMatrix = depthNerve.getNerveMatrix();
            this.insertMatrix(nerveMatrix, list);
        }
        Nerve outNerve = this.outNerves.get(0);
        Matrix outNerveMatrix = outNerve.getNerveMatrix();
        List<Float> list = dymOutNerveStudy.getList();
        this.insertMatrix(outNerveMatrix, list);
    }

    private void insertMatrix(Matrix matrix, List<Float> list) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            matrix.setNub(i, 0, list.get(i).floatValue());
        }
    }

    private void insertRnnModelParameter(ModelParameter modelParameter) throws Exception {
        List<List<NerveStudy>> depthStudyNerves = modelParameter.getDepthNerves();
        List<RnnOutNerveStudy> rnnOutNerveStudies = modelParameter.getRnnOutNerveStudies();
        this.depthNervesModel(depthStudyNerves);
        for (RnnOutNerveStudy rnnOutNerveStudy : rnnOutNerveStudies) {
            RnnOutNerveBody rnnOutNerveBody = this.getRnnOutNerveBody(rnnOutNerveStudy.getDepth());
            List<NerveStudy> outStudyNerves = rnnOutNerveStudy.getNerveStudies();
            List<Nerve> outNerveBody = rnnOutNerveBody.getOutNerves();
            this.outNerveModel(outStudyNerves, outNerveBody);
        }
    }

    private void outNerveModel(List<NerveStudy> outStudyNerves, List<Nerve> outNerveBody) {
        for (int i = 0; i < outNerveBody.size(); ++i) {
            Nerve outNerve = outNerveBody.get(i);
            NerveStudy nerveStudy = outStudyNerves.get(i);
            outNerve.setThreshold(nerveStudy.getThreshold());
            Map<Integer, Float> dendrites = outNerve.getDendrites();
            Map<Integer, Float> studyDendrites = this.unConversion(nerveStudy.getDendrites());
            for (Map.Entry<Integer, Float> outEntry : dendrites.entrySet()) {
                int key = outEntry.getKey();
                dendrites.put(key, studyDendrites.get(key));
            }
        }
    }

    private void depthNervesModel(List<List<NerveStudy>> depthStudyNerves) {
        for (int i = 0; i < this.depthNerves.size(); ++i) {
            List<NerveStudy> depth = depthStudyNerves.get(i);
            List<Nerve> depthNerve = this.depthNerves.get(i);
            for (int j = 0; j < depthNerve.size(); ++j) {
                Nerve nerve = depthNerve.get(j);
                NerveStudy nerveStudy = depth.get(j);
                Map<Integer, Float> studyDendrites = this.unConversion(nerveStudy.getDendrites());
                Map<Integer, Float> dendrites = nerve.getDendrites();
                nerve.setThreshold(nerveStudy.getThreshold());
                for (Map.Entry<Integer, Float> entry : dendrites.entrySet()) {
                    int key = entry.getKey();
                    dendrites.put(key, studyDendrites.get(key));
                }
            }
        }
    }

    private RnnOutNerveBody getRnnOutNerveBody(int depth) {
        RnnOutNerveBody myRnnOutNerveBody = null;
        for (RnnOutNerveBody rnnOutNerveBody : this.rnnOutNerveBodies) {
            if (rnnOutNerveBody.getDepth() != depth) continue;
            myRnnOutNerveBody = rnnOutNerveBody;
            break;
        }
        return myRnnOutNerveBody;
    }

    private void insertBpModelParameter(ModelParameter modelParameter) {
        List<List<NerveStudy>> depthStudyNerves = modelParameter.getDepthNerves();
        List<NerveStudy> outStudyNerves = modelParameter.getOutNerves();
        this.depthNervesModel(depthStudyNerves);
        this.outNerveModel(outStudyNerves, this.outNerves);
    }

    public NerveJumpManager(int sensoryNerveNub, int hiddenNerveNub, int outNerveNub, int hiddenDepth, ActiveFunction activeFunction, boolean isDynamic, float studyPoint, int rzType, float lParam) throws Exception {
        if (sensoryNerveNub > 0 && hiddenNerveNub > 0 && outNerveNub > 0 && hiddenDepth > 0 && activeFunction != null) {
            this.hiddenNerveNub = hiddenNerveNub;
            this.sensoryNerveNub = sensoryNerveNub;
            this.outNerveNub = outNerveNub;
            this.hiddenDepth = hiddenDepth;
            this.activeFunction = activeFunction;
            this.isDynamic = isDynamic;
            this.rzType = rzType;
            this.lParam = lParam;
            if (studyPoint > 0.0f && studyPoint < 1.0f) {
                this.studyPoint = studyPoint;
            }
        } else {
            throw new Exception("param is null");
        }
    }

    public List<SensoryNerve> getSensoryNerves() {
        return this.sensoryNerves;
    }

    public void init(boolean initPower, boolean isShowLog, boolean isSoftMax, int step, int kernLen) throws Exception {
        this.initPower = initPower;
        this.initDepthNerve(false, 0);
        List<Nerve> nerveList = this.depthNerves.get(0);
        List<Nerve> lastNerveList = this.depthNerves.get(this.depthNerves.size() - 1);
        ArrayList<OutNerve> outNerveList = new ArrayList<OutNerve>();
        for (int i = 1; i < this.outNerveNub + 1; ++i) {
            OutNerve outNerve = new OutNerve(i, this.studyPoint, initPower, this.activeFunction, isShowLog, this.rzType, this.lParam, isSoftMax, this.sensoryNerveNub, this.hiddenNerveNub, this.outNerveNub, this.hiddenDepth);
            outNerve.connectFather(0, lastNerveList);
            this.outNerves.add(outNerve);
            outNerveList.add(outNerve);
        }
        if (isSoftMax) {
            SoftMax softMax = new SoftMax(outNerveList, isShowLog, this.sensoryNerveNub, this.hiddenNerveNub, this.outNerveNub, this.hiddenDepth);
            this.softMaxList.add(softMax);
            for (Nerve nerve : this.outNerves) {
                nerve.connect(0, this.softMaxList);
            }
        }
        for (Nerve nerve : lastNerveList) {
            nerve.connect(0, this.outNerves);
        }
        for (int i = 1; i < this.sensoryNerveNub + 1; ++i) {
            SensoryNerve sensoryNerve = new SensoryNerve(i, this.hiddenDepth);
            sensoryNerve.connect(0, nerveList);
            this.sensoryNerves.add(sensoryNerve);
        }
    }

    private void createRnnOutNerve(boolean initPower, boolean isShowLog, List<Nerve> nerveList, int depth, boolean toSoftMax) throws Exception {
        RnnOutNerveBody rnnOutNerveBody = new RnnOutNerveBody();
        ArrayList<Nerve> mySoftMaxList = new ArrayList<Nerve>();
        ArrayList<Nerve> rnnOutNerves = new ArrayList<Nerve>();
        ArrayList<OutNerve> layOutNerves = new ArrayList<OutNerve>();
        rnnOutNerveBody.setDepth(depth);
        rnnOutNerveBody.setOutNerves(rnnOutNerves);
        NerveCenter nerveCenter = this.nerveCenterList.get(depth);
        for (int i = 1; i < this.outNerveNub + 1; ++i) {
            OutNerve outNerve = new OutNerve(i, this.studyPoint, initPower, this.activeFunction, isShowLog, this.rzType, this.lParam, toSoftMax, this.sensoryNerveNub, this.hiddenNerveNub, this.outNerveNub, this.hiddenDepth);
            outNerve.connectFather(depth, nerveList);
            rnnOutNerves.add(outNerve);
            layOutNerves.add(outNerve);
        }
        if (toSoftMax) {
            SoftMax softMax = new SoftMax(layOutNerves, isShowLog, this.sensoryNerveNub, this.hiddenNerveNub, this.outNerveNub, this.hiddenDepth);
            softMax.setNerveCenter(nerveCenter);
            mySoftMaxList.add(softMax);
            for (Nerve nerve : rnnOutNerves) {
                nerve.connect(0, mySoftMaxList);
            }
        }
        for (Nerve nerve : nerveList) {
            nerve.connectOut(rnnOutNerves);
        }
        this.rnnOutNerveBodies.add(rnnOutNerveBody);
    }

    public void initRnn(boolean initPower, boolean isShowLog, boolean toSoftMax, boolean creator, int startDepth) throws Exception {
        int i;
        this.isRnn = true;
        this.initPower = initPower;
        this.initDepthNerve(creator, startDepth);
        for (i = 0; i < this.depthNerves.size(); ++i) {
            this.createRnnOutNerve(initPower, isShowLog, this.depthNerves.get(i), i + 1, toSoftMax);
        }
        for (i = 1; i < this.sensoryNerveNub + 1; ++i) {
            SensoryNerve sensoryNerve = new SensoryNerve(i, this.hiddenDepth);
            for (int j = 0; j < this.hiddenDepth; ++j) {
                List<Nerve> hiddenNerveList = this.depthNerves.get(j);
                sensoryNerve.connect(j + 1, hiddenNerveList);
            }
            this.sensoryNerves.add(sensoryNerve);
        }
    }

    private void initDepthNerve(boolean creator, int startDepth) throws Exception {
        if (this.isRnn) {
            NerveCenter nerveCenter = new NerveCenter(0, null, this.powerTh, false);
            this.nerveCenterList.add(nerveCenter);
        }
        for (int i = 0; i < this.hiddenDepth; ++i) {
            ArrayList<Nerve> hiddenNerveList = new ArrayList<Nerve>();
            float studyPoint = this.studyPoint;
            if (studyPoint <= 0.0f || studyPoint > 1.0f) {
                throw new Exception("studyPoint Values range from 0 to 1");
            }
            if (this.isRnn) {
                boolean isFinish = i == this.hiddenDepth - 1;
                NerveCenter nerveCenter = new NerveCenter(i + 1, hiddenNerveList, this.powerTh, isFinish);
                this.nerveCenterList.add(nerveCenter);
            }
            for (int j = 1; j < this.hiddenNerveNub + 1; ++j) {
                HiddenNerve hiddenNerve = new HiddenNerve(j, i + 1, studyPoint, this.initPower, this.activeFunction, this.rzType, this.lParam, this.sensoryNerveNub, this.hiddenNerveNub, this.outNerveNub, this.hiddenDepth, creator, startDepth);
                hiddenNerveList.add(hiddenNerve);
            }
            this.depthNerves.add(hiddenNerveList);
        }
        if (this.isRnn) {
            this.initRnnHiddenNerve();
        } else {
            this.initHiddenNerve();
        }
    }

    private void initHiddenNerve() {
        for (int i = 0; i < this.hiddenDepth - 1; ++i) {
            List<Nerve> hiddenNerveList = this.depthNerves.get(i);
            List<Nerve> nextHiddenNerveList = this.depthNerves.get(i + 1);
            for (Nerve nerve : hiddenNerveList) {
                nerve.connect(0, nextHiddenNerveList);
            }
            for (Nerve nerve : nextHiddenNerveList) {
                nerve.connectFather(0, hiddenNerveList);
            }
        }
    }

    private void initRnnHiddenNerve() {
        for (int i = 0; i < this.hiddenDepth; ++i) {
            List<Nerve> nextHiddenNerveList;
            List<Nerve> hiddenNerveList = this.depthNerves.get(i);
            if (i < this.hiddenDepth - 1) {
                for (int j = i + 1; j < this.hiddenDepth; ++j) {
                    nextHiddenNerveList = this.depthNerves.get(j);
                    for (Nerve hiddenNerve : hiddenNerveList) {
                        hiddenNerve.connect(j + 1, nextHiddenNerveList);
                    }
                }
            }
            if (i <= 0) continue;
            for (int t = i - 1; t >= 0; --t) {
                nextHiddenNerveList = this.depthNerves.get(t);
                for (Nerve hiddenNerve : hiddenNerveList) {
                    hiddenNerve.connectFather(t + 1, nextHiddenNerveList);
                }
            }
        }
    }
}

