/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.rnnJumpNerveEntity;

import java.util.HashMap;
import java.util.Map;
import org.dromara.easyai.i.ActiveFunction;
import org.dromara.easyai.i.OutBack;
import org.dromara.easyai.matrixTools.Matrix;
import org.dromara.easyai.rnnJumpNerveEntity.Nerve;

public class HiddenNerve
extends Nerve {
    private final Map<Long, Float> outMap = new HashMap<Long, Float>();

    public HiddenNerve(int id, int depth, float studyPoint, boolean init, ActiveFunction activeFunction, int rzType, float lParam, int sensoryNerveNub, int hiddenNerveNub, int outNerveNub, int allDepth, boolean creator, int startDepth) throws Exception {
        super(id, "HiddenNerve", studyPoint, init, activeFunction, rzType, lParam, sensoryNerveNub, hiddenNerveNub, outNerveNub, allDepth, creator, startDepth);
        this.depth = depth;
    }

    @Override
    public void input(long eventId, float parameter, boolean isKernelStudy, Map<Integer, Float> E, OutBack outBack, Matrix rnnMatrix, int[] storeys, int index, int questionLength) throws Exception {
        boolean allReady = this.insertParameter(eventId, parameter);
        if (allReady) {
            float sigma = this.calculation(eventId);
            float out = this.activeFunction.function(sigma);
            if (isKernelStudy) {
                this.outNub = out;
            }
            if (rnnMatrix != null) {
                out = !this.creator || this.depth < this.startDepth ? (out += rnnMatrix.getNumber(this.depth, this.getId() - 1)) : (out += rnnMatrix.getNumber(this.depth - this.startDepth + questionLength, this.getId() - 1));
            }
            if (!isKernelStudy) {
                this.destroyParameter(eventId);
            }
            this.sendMessage(eventId, out, isKernelStudy, E, outBack, rnnMatrix, storeys, index, questionLength);
        }
    }

    @Override
    protected void sendAppointTestMessage(long eventId, float parameter, Matrix featureMatrix, OutBack outBack, String myWord) throws Exception {
        boolean allReady = this.insertParameter(eventId, parameter);
        if (allReady) {
            float sigma = this.calculation(eventId);
            float out = this.activeFunction.function(sigma);
            this.destroyParameter(eventId);
            this.outMap.put(eventId, Float.valueOf(out += featureMatrix.getNumber(featureMatrix.getX() - 1, this.getId() - 1)));
            this.sendRnnTestMessage(eventId, out, featureMatrix, outBack, myWord);
        }
    }

    @Override
    protected void sendMyTestMessage(long eventId, Matrix featureMatrix, OutBack outBack, String word) throws Exception {
        float out = this.outMap.get(eventId).floatValue();
        this.outMap.remove(eventId);
        this.sendTestMessage(eventId, out, featureMatrix, outBack, word);
    }

    @Override
    protected void clearData(long eventId) {
        this.outMap.remove(eventId);
    }
}

