/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.rnnJumpNerveEntity;

import java.util.List;
import org.dromara.easyai.i.OutBack;
import org.dromara.easyai.matrixTools.Matrix;
import org.dromara.easyai.matrixTools.MatrixOperation;
import org.dromara.easyai.naturalLanguage.word.WordEmbedding;
import org.dromara.easyai.rnnJumpNerveEntity.Nerve;

public class NerveCenter
extends MatrixOperation {
    private final int depth;
    private final float powerTh;
    private final List<Nerve> nerveList;
    private WordEmbedding wordEmbedding;
    private final boolean isFinish;

    public int getDepth() {
        return this.depth;
    }

    public NerveCenter(int depth, List<Nerve> nerveList, float powerTh, boolean isFinish) {
        this.depth = depth;
        this.nerveList = nerveList;
        this.powerTh = powerTh;
        this.isFinish = isFinish;
    }

    public void setWordEmbedding(WordEmbedding wordEmbedding) {
        this.wordEmbedding = wordEmbedding;
    }

    public void backType(long eventId, float parameter, int id, Matrix featureMatrix, OutBack outBack, String myWord) throws Exception {
        if (id > 0 && parameter > this.powerTh) {
            String nextWord = this.wordEmbedding.getWord(id - 1);
            myWord = myWord == null ? nextWord : myWord + nextWord;
            if (this.isFinish) {
                outBack.backWord(myWord, eventId);
            } else {
                Matrix matrix = this.wordEmbedding.getEmbedding(nextWord, eventId, false).getFeatureMatrix();
                featureMatrix = this.pushVector(featureMatrix, matrix, true);
                this.go(eventId, featureMatrix, outBack, myWord);
            }
        } else {
            outBack.backWord(myWord, eventId);
        }
    }

    private void go(long eventId, Matrix featureMatrix, OutBack outBack, String word) throws Exception {
        for (Nerve nerve : this.nerveList) {
            nerve.sendMyTestMessage(eventId, featureMatrix, outBack, word);
        }
    }
}

