/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.rnnNerveEntity;

import java.util.Map;
import org.dromara.easyai.i.ActiveFunction;
import org.dromara.easyai.i.OutBack;
import org.dromara.easyai.matrixTools.Matrix;
import org.dromara.easyai.rnnNerveEntity.Nerve;

public class HiddenNerve
extends Nerve {
    private final int depth;

    public HiddenNerve(int id, int depth, int upNub, int downNub, float studyPoint, boolean init, ActiveFunction activeFunction, int rzType, float lParam, int rnnOutNumber) throws Exception {
        super(id, upNub, "HiddenNerve", downNub, studyPoint, init, activeFunction, rzType, lParam, rnnOutNumber);
        this.depth = depth;
    }

    @Override
    public void input(long eventId, float parameter, boolean isKernelStudy, Map<Integer, Float> E, OutBack outBack, boolean isEmbedding, Matrix rnnMatrix) throws Exception {
        boolean allReady = this.insertParameter(eventId, parameter, isEmbedding);
        if (allReady) {
            if (isEmbedding && !isKernelStudy) {
                outBack.getWordVector(this.getId(), this.getWOne(eventId));
                this.destoryParameter(eventId);
            } else {
                float sigma = this.calculation(eventId, isEmbedding);
                float out = this.activeFunction.function(sigma);
                if (rnnMatrix != null) {
                    out += rnnMatrix.getNumber(this.depth, this.getId() - 1);
                }
                if (isKernelStudy) {
                    this.outNub = out;
                } else {
                    this.destoryParameter(eventId);
                }
                if (rnnMatrix != null && rnnMatrix.getX() == this.depth + 1) {
                    this.sendRnnMessage(eventId, out, isKernelStudy, E, outBack, false, rnnMatrix);
                } else {
                    this.sendMessage(eventId, out, isKernelStudy, E, outBack, false, rnnMatrix);
                }
            }
        }
    }
}

