/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.tools;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import org.dromara.easyai.entity.ThreeChannelMatrix;
import org.dromara.easyai.matrixTools.Matrix;
import org.dromara.easyai.yolo.OutBox;

public class ImageTools {
    public static void writeImage(ThreeChannelMatrix img, String url) {
        ByteArrayOutputStream b = null;
        FileOutputStream fileOutputStream = null;
        try {
            b = ImageTools.drawImage(img);
            fileOutputStream = new FileOutputStream(url);
            b.writeTo(fileOutputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (b != null) {
                    b.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void drawBox(String fileURL, List<OutBox> borderFoods, String outFileName, int fontSize) throws Exception {
        File file = new File(fileURL);
        BufferedImage image2 = ImageIO.read(file);
        int width = image2.getWidth();
        int height = image2.getHeight();
        BufferedImage bi = new BufferedImage(width, height, 1);
        Graphics2D g2 = (Graphics2D)bi.getGraphics();
        g2.drawImage(image2, 0, 0, width, height, null);
        g2.setFont(new Font(null, 1, fontSize));
        for (OutBox borderFood : borderFoods) {
            Rectangle2D.Float rect = new Rectangle2D.Float(borderFood.getX(), borderFood.getY(), borderFood.getWidth(), borderFood.getHeight());
            g2.setColor(Color.RED);
            g2.draw(rect);
            g2.setColor(Color.BLUE);
            g2.drawString(borderFood.getTypeID(), borderFood.getX() + 10, borderFood.getY() + 10);
        }
        ImageIO.write((RenderedImage)bi, "jpg", new FileOutputStream(outFileName));
    }

    public static ByteArrayOutputStream drawImage(ThreeChannelMatrix img) throws Exception {
        BufferedImage bufferedImage = ImageTools.getBufferedImage(img);
        ByteArrayOutputStream ar = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "PNG", ar);
        return ar;
    }

    public static File drawImage(ThreeChannelMatrix img, String imageName) throws Exception {
        BufferedImage bufferedImage = ImageTools.getBufferedImage(img);
        File ar = new File(imageName);
        ImageIO.write((RenderedImage)bufferedImage, "PNG", ar);
        return ar;
    }

    private static BufferedImage getBufferedImage(ThreeChannelMatrix img) throws Exception {
        Matrix matrixR = img.getMatrixR();
        Matrix matrixG = img.getMatrixG();
        Matrix matrixB = img.getMatrixB();
        int x = img.getX();
        int y = img.getY();
        BufferedImage bi = new BufferedImage(img.getY(), img.getX(), 1);
        Graphics2D g2 = (Graphics2D)bi.getGraphics();
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                int r = (int)((double)matrixR.getNumber(i, j) * 255.0);
                int g = (int)((double)matrixG.getNumber(i, j) * 255.0);
                int b = (int)((double)matrixB.getNumber(i, j) * 255.0);
                if (r > 255) {
                    r = 255;
                } else if (r < 0) {
                    r = 0;
                }
                if (g > 255) {
                    g = 255;
                } else if (g < 0) {
                    g = 0;
                }
                if (b > 255) {
                    b = 255;
                } else if (b < 0) {
                    b = 0;
                }
                g2.setColor(new Color(r, g, b));
                g2.drawRect(j, i, 1, 1);
            }
        }
        return bi;
    }
}

