/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.tools;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.dromara.easyai.entity.RGBNorm;
import org.dromara.easyai.tools.MeanSort;

public class MeanClustering {
    protected List<float[]> matrixList = new ArrayList<float[]>();
    private int length;
    protected int speciesQuantity;
    private final int maxTimes;
    protected List<RGBNorm> matrices = new ArrayList<RGBNorm>();

    public List<RGBNorm> getMatrices() {
        return this.matrices;
    }

    public float[] getResultByNorm() {
        MeanSort meanSort = new MeanSort();
        float[] dm = new float[this.matrices.size() * this.length];
        this.matrices.sort(meanSort);
        for (int i = 0; i < this.matrices.size(); ++i) {
            RGBNorm rgbNorm = this.matrices.get(i);
            float[] rgb = rgbNorm.getRgb();
            for (int j = 0; j < rgb.length; ++j) {
                dm[i * rgb.length + j] = rgb[j];
            }
        }
        return dm;
    }

    public MeanClustering(int speciesQuantity, int maxTimes) throws Exception {
        this.speciesQuantity = speciesQuantity;
        this.maxTimes = maxTimes;
    }

    public void setFeature(float[] feature) throws Exception {
        if (this.matrixList.isEmpty()) {
            this.matrixList.add(feature);
            this.length = feature.length;
        } else if (this.length == feature.length) {
            this.matrixList.add(feature);
        } else {
            throw new Exception("vector length is different");
        }
    }

    private void averageMatrix() {
        for (float[] rgb : this.matrixList) {
            float min = -1.0f;
            int id = 0;
            for (int i = 0; i < this.speciesQuantity; ++i) {
                RGBNorm rgbNorm = this.matrices.get(i);
                float dist = rgbNorm.getEDist(rgb);
                if (min != -1.0f && !(dist < min)) continue;
                min = dist;
                id = i;
            }
            RGBNorm rgbNorm = this.matrices.get(id);
            rgbNorm.setColor(rgb);
        }
        for (RGBNorm rgbNorm : this.matrices) {
            rgbNorm.norm();
        }
    }

    private boolean isNext() {
        RGBNorm rgbNorm;
        boolean isNext = false;
        Iterator<RGBNorm> iterator = this.matrices.iterator();
        while (iterator.hasNext() && !(isNext = (rgbNorm = iterator.next()).compare())) {
        }
        return isNext;
    }

    private void clear() {
        for (RGBNorm rgbNorm : this.matrices) {
            rgbNorm.clear();
        }
    }

    public void start() throws Exception {
        if (this.matrixList.size() > 1) {
            Random random = new Random();
            for (int i = 0; i < this.speciesQuantity; ++i) {
                int index = random.nextInt(this.matrixList.size());
                float[] rgb = this.matrixList.get(index);
                RGBNorm rgbNorm = new RGBNorm(rgb, this.length);
                this.matrices.add(rgbNorm);
            }
            for (int i = 0; i < this.maxTimes; ++i) {
                this.averageMatrix();
                boolean isNext = this.isNext();
                if (isNext && i < this.maxTimes - 1) {
                    this.clear();
                    continue;
                }
                break;
            }
        } else {
            throw new Exception("matrixList number less than 2");
        }
    }
}

