/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.tools;

import java.util.ArrayList;
import java.util.List;
import org.dromara.easyai.matrixTools.Matrix;

public class RegionBody {
    private int minX = -1;
    private int minY = -1;
    private int maxX;
    private int maxY;
    private int type;
    private int xSize;
    private int ySize;
    private List<Integer> pointList = new ArrayList<Integer>();
    private Matrix regionMap;

    RegionBody(Matrix regionMap, int type, int xSize, int ySize) {
        this.regionMap = regionMap;
        this.type = type;
        this.xSize = xSize;
        this.ySize = ySize;
    }

    public List<Integer> getPointList() {
        return this.pointList;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void mergeRegion(RegionBody regionBody) throws Exception {
        List<Integer> list = regionBody.getPointList();
        for (int pixel : list) {
            int x = pixel >> 12;
            int y = pixel & 0xFFF;
            this.setPoint(x, y);
        }
    }

    public void setPoint(int x, int y) throws Exception {
        if (x < this.minX || this.minX == -1) {
            this.minX = x;
        }
        if (x > this.maxX) {
            this.maxX = x;
        }
        if (y < this.minY || this.minY == -1) {
            this.minY = y;
        }
        if (y > this.maxY) {
            this.maxY = y;
        }
        int pixel = x << 12 | y;
        this.pointList.add(pixel);
        this.regionMap.setNub(x, y, this.type);
    }

    public void setX(int x) {
        if (x < this.minX || this.minX == -1) {
            this.minX = x;
        }
        if (x > this.maxX) {
            this.maxX = x;
        }
    }

    public void setY(int y) {
        if (y < this.minY || this.minY == -1) {
            this.minY = y;
        }
        if (y > this.maxY) {
            this.maxY = y;
        }
    }

    public int getMinX() {
        return this.minX * this.xSize;
    }

    public int getMinY() {
        return this.minY * this.ySize;
    }

    public int getMaxX() {
        return this.maxX * this.xSize;
    }

    public int getMaxY() {
        return this.maxY * this.ySize;
    }
}

