/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dromara.easyai.config.WaterConfig;
import org.dromara.easyai.entity.Box;
import org.dromara.easyai.entity.ThreeChannelMatrix;
import org.dromara.easyai.matrixTools.Matrix;
import org.dromara.easyai.tools.RegionBody;

public class Watershed {
    private final Matrix matrix;
    private final Matrix rainfallMap;
    private final Matrix regionMap;
    private final int xSize;
    private final int ySize;
    private final float rainTh;
    private final int regionNub;
    private final Map<Integer, RegionBody> regionBodyMap = new HashMap<Integer, RegionBody>();
    private final int xMax;
    private final int yMax;
    private final int cutMinXSize;
    private final int cutMinYSize;
    private final int cutMaxXSize;
    private final int cutMaxYSize;
    private final float th;

    public Watershed(ThreeChannelMatrix matrix, WaterConfig config) throws Exception {
        if (matrix != null) {
            this.th = config.getTh();
            if (this.th < 0.0f) {
                throw new Exception("\u843d\u5dee\u4e0d\u80fd\u5c0f\u4e8e0");
            }
        } else {
            throw new Exception("matrix is null");
        }
        this.cutMaxXSize = config.getCutMaxXSize();
        this.cutMaxYSize = config.getCutMaxYSize();
        this.cutMinXSize = config.getMinXSizeTh() + 2;
        this.cutMinYSize = config.getMinYSizeTh() + 2;
        this.rainTh = config.getRainTh();
        this.regionNub = config.getRegionNub();
        this.matrix = matrix.getH();
        this.xSize = this.matrix.getX() / this.regionNub;
        this.ySize = this.matrix.getY() / this.regionNub;
        this.rainfallMap = new Matrix(this.matrix.getX(), this.matrix.getY());
        this.regionMap = new Matrix(this.regionNub, this.regionNub);
        this.xMax = this.rainfallMap.getX() - 1;
        this.yMax = this.rainfallMap.getY() - 1;
    }

    private float[] getPixels(int x, int y) throws Exception {
        float left = -1.0f;
        float leftTop = -1.0f;
        float leftBottom = -1.0f;
        float right = -1.0f;
        float rightTop = -1.0f;
        float rightBottom = -1.0f;
        float top = -1.0f;
        float bottom = -1.0f;
        if (x == 0) {
            top = 1.0f;
            leftTop = 1.0f;
            rightTop = 1.0f;
        }
        if (y == 0) {
            leftTop = 1.0f;
            left = 1.0f;
            leftBottom = 1.0f;
        }
        if (x == this.xMax) {
            leftBottom = 1.0f;
            bottom = 1.0f;
            rightBottom = 1.0f;
        }
        if (y == this.yMax) {
            rightTop = 1.0f;
            right = 1.0f;
            rightBottom = 1.0f;
        }
        if (top == -1.0f && this.rainfallMap.getNumber(x - 1, y) == 0.0f) {
            top = this.matrix.getNumber(x - 1, y);
        }
        if (left == -1.0f && this.rainfallMap.getNumber(x, y - 1) == 0.0f) {
            left = this.matrix.getNumber(x, y - 1);
        }
        if (bottom == -1.0f && this.rainfallMap.getNumber(x + 1, y) == 0.0f) {
            bottom = this.matrix.getNumber(x + 1, y);
        }
        if (right == -1.0f && this.rainfallMap.getNumber(x, y + 1) == 0.0f) {
            right = this.matrix.getNumber(x, y + 1);
        }
        if (leftTop == -1.0f && this.rainfallMap.getNumber(x - 1, y - 1) == 0.0f) {
            leftTop = this.matrix.getNumber(x - 1, y - 1);
        }
        if (leftBottom == -1.0f && this.rainfallMap.getNumber(x + 1, y - 1) == 0.0f) {
            leftBottom = this.matrix.getNumber(x + 1, y - 1);
        }
        if (rightTop == -1.0f && this.rainfallMap.getNumber(x - 1, y + 1) == 0.0f) {
            rightTop = this.matrix.getNumber(x - 1, y + 1);
        }
        if (rightBottom == -1.0f && this.rainfallMap.getNumber(x + 1, y + 1) == 0.0f) {
            rightBottom = this.matrix.getNumber(x + 1, y + 1);
        }
        return new float[]{top, left, bottom, right, leftTop, leftBottom, rightBottom, rightTop};
    }

    private int[] rain(int x, int y) throws Exception {
        float[] pixels = this.getPixels(x, y);
        int[] point = new int[8];
        float mySelf = this.matrix.getNumber(x, y);
        int index = this.getMinIndex(pixels, mySelf);
        if (index > 0) {
            for (int i = 0; i < 8; ++i) {
                int pixel;
                int t = index & 1 << i;
                if (t <= 0) continue;
                int row = x;
                int column = y;
                switch (i) {
                    case 0: {
                        row = x - 1;
                        break;
                    }
                    case 1: {
                        column = y - 1;
                        break;
                    }
                    case 2: {
                        row = x + 1;
                        break;
                    }
                    case 3: {
                        column = y + 1;
                        break;
                    }
                    case 4: {
                        column = y - 1;
                        row = x - 1;
                        break;
                    }
                    case 5: {
                        column = y - 1;
                        row = x + 1;
                        break;
                    }
                    case 6: {
                        column = y + 1;
                        row = x + 1;
                        break;
                    }
                    case 7: {
                        column = y + 1;
                        row = x - 1;
                    }
                }
                point[i] = pixel = row << 12 | column;
                this.rainfallMap.setNub(row, column, 1.0f);
            }
        }
        return point;
    }

    private void pull(List<Integer> list, int[] points) {
        for (int point : points) {
            if (point == 0) continue;
            list.add(point);
        }
    }

    private void fall(int i, int j) throws Exception {
        ArrayList<Integer> list2;
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(i << 12 | j);
        do {
            list2 = new ArrayList<Integer>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int pixel = (Integer)iterator.next();
                int x = pixel >> 12;
                int y = pixel & 0xFFF;
                int[] nodes = this.rain(x, y);
                this.pull(list2, nodes);
            }
        } while (!(list = list2).isEmpty());
    }

    public List<Box> rainfall() throws Exception {
        int x = this.matrix.getX();
        int y = this.matrix.getY();
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                if (this.rainfallMap.getNumber(i, j) != 0.0f) continue;
                this.fall(i, j);
            }
        }
        this.sigmaPixel();
        ArrayList<Box> boxes = new ArrayList<Box>();
        for (Map.Entry<Integer, RegionBody> entry : this.regionBodyMap.entrySet()) {
            RegionBody regionBody = entry.getValue();
            int minX = regionBody.getMinX();
            int maxX = regionBody.getMaxX();
            int minY = regionBody.getMinY();
            int maxY = regionBody.getMaxY();
            int xSize = maxX - minX;
            int ySize = maxY - minY;
            if (xSize < this.cutMinXSize || ySize < this.cutMinYSize || xSize >= this.cutMaxXSize || ySize >= this.cutMaxYSize) continue;
            Box box = new Box();
            box.setX(minX);
            box.setY(minY);
            box.setRealX(minX + xSize / 2);
            box.setRealY(minY + ySize / 2);
            box.setxSize(xSize);
            box.setySize(ySize);
            boxes.add(box);
        }
        return boxes;
    }

    private void merge() throws Exception {
        int xSize = this.regionMap.getX();
        int ySize = this.regionMap.getY();
        for (int i = 0; i < xSize - 1; ++i) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int j = 0; j < ySize; ++j) {
                int otherType;
                int type = (int)this.regionMap.getNumber(i, j);
                if (type <= 1 || i + 1 >= this.regionNub || (otherType = (int)this.regionMap.getNumber(i + 1, j)) <= 1 || otherType == type || list.contains(otherType)) continue;
                RegionBody myRegion = this.regionBodyMap.get(type);
                RegionBody otherRegion = this.regionBodyMap.get(otherType);
                myRegion.mergeRegion(otherRegion);
                this.regionBodyMap.remove(otherType);
                list.add(otherType);
            }
        }
    }

    private void createMerge() throws Exception {
        int x = this.regionMap.getX();
        int y = this.regionMap.getY();
        int t = 0;
        boolean isZero = false;
        for (int i = 0; i < x; ++i) {
            if (!isZero) {
                ++t;
            }
            boolean isFirstOne = false;
            for (int j = 0; j < y; ++j) {
                int type = (int)this.regionMap.getNumber(i, j);
                if (type == 1) {
                    RegionBody regionBody;
                    if (this.regionBodyMap.containsKey(t)) {
                        regionBody = this.regionBodyMap.get(t);
                    } else {
                        regionBody = new RegionBody(this.regionMap, t, this.xSize, this.ySize);
                        this.regionBodyMap.put(t, regionBody);
                    }
                    regionBody.setPoint(i, j);
                    isFirstOne = true;
                    isZero = false;
                    continue;
                }
                if (!isFirstOne) continue;
                if (!isZero) {
                    ++t;
                }
                isZero = true;
            }
        }
    }

    private void sigmaPixel() throws Exception {
        int size = this.xSize * this.ySize;
        for (int i = 0; i < this.xSize * this.regionNub; i += this.xSize) {
            for (int j = 0; j < this.ySize * this.regionNub; j += this.ySize) {
                Matrix myMatrix = this.rainfallMap.getSonOfMatrix(i, j, this.xSize, this.ySize);
                int sigma = 0;
                for (int t = 0; t < this.xSize; ++t) {
                    for (int f = 0; f < this.ySize; ++f) {
                        if (!((double)myMatrix.getNumber(t, f) > 0.1)) continue;
                        ++sigma;
                    }
                }
                float cover = (float)sigma / (float)size;
                if (!(cover > this.rainTh)) continue;
                this.regionMap.setNub(i / this.xSize, j / this.ySize, 1.0f);
            }
        }
        this.createMerge();
        this.merge();
    }

    private int getMinIndex(float[] array, float mySelf) {
        int minIdx = 0;
        for (int i = 0; i < array.length; ++i) {
            float nub = array[i];
            float sub = mySelf - nub;
            if (!(nub > -1.0f) || !(sub > this.th)) continue;
            minIdx |= 1 << i;
        }
        return minIdx;
    }
}

