/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.transFormer;

import java.util.ArrayList;
import java.util.List;
import org.dromara.easyai.function.ReLu;
import org.dromara.easyai.i.OutBack;
import org.dromara.easyai.matrixTools.Matrix;
import org.dromara.easyai.matrixTools.MatrixOperation;
import org.dromara.easyai.transFormer.CodecBlock;
import org.dromara.easyai.transFormer.model.LineBlockModel;
import org.dromara.easyai.transFormer.nerve.HiddenNerve;
import org.dromara.easyai.transFormer.nerve.Nerve;
import org.dromara.easyai.transFormer.nerve.OutNerve;
import org.dromara.easyai.transFormer.nerve.SoftMax;

public class LineBlock {
    private final List<HiddenNerve> hiddenNerveList = new ArrayList<HiddenNerve>();
    private final List<OutNerve> outNerveList = new ArrayList<OutNerve>();
    private final CodecBlock lastCodecBlock;
    private Matrix allError;
    private final int featureDimension;
    private int backNumber = 0;
    private final MatrixOperation matrixOperation;

    public LineBlockModel getModel() throws Exception {
        LineBlockModel lineBlockModel = new LineBlockModel();
        ArrayList<float[][]> hiddenNerveModel = new ArrayList<float[][]>();
        ArrayList<float[][]> outNerveModel = new ArrayList<float[][]>();
        for (HiddenNerve hiddenNerve : this.hiddenNerveList) {
            hiddenNerveModel.add(hiddenNerve.getModel());
        }
        for (OutNerve outNerve : this.outNerveList) {
            outNerveModel.add(outNerve.getModel());
        }
        lineBlockModel.setHiddenNervesModel(hiddenNerveModel);
        lineBlockModel.setOutNervesModel(outNerveModel);
        return lineBlockModel;
    }

    public void insertModel(LineBlockModel lineBlockModel) throws Exception {
        int i;
        List<float[][]> hiddenNerveModel = lineBlockModel.getHiddenNervesModel();
        List<float[][]> outNerveModel = lineBlockModel.getOutNervesModel();
        for (i = 0; i < this.hiddenNerveList.size(); ++i) {
            this.hiddenNerveList.get(i).insertModel(hiddenNerveModel.get(i));
        }
        for (i = 0; i < this.outNerveList.size(); ++i) {
            this.outNerveList.get(i).insertModel(outNerveModel.get(i));
        }
    }

    public LineBlock(int typeNumber, int featureDimension, float studyPoint, CodecBlock lastCodecBlock, boolean showLog, int regularModel, float regular, int coreNumber, float timePunValue) throws Exception {
        this.featureDimension = featureDimension;
        this.lastCodecBlock = lastCodecBlock;
        this.matrixOperation = new MatrixOperation(coreNumber);
        SoftMax softMax = new SoftMax(this.outNerveList, showLog, typeNumber, typeNumber, typeNumber, timePunValue);
        ArrayList<Nerve> hiddenNerves = new ArrayList<Nerve>();
        for (int i = 0; i < featureDimension; ++i) {
            HiddenNerve hiddenNerve = new HiddenNerve(i + 1, 1, studyPoint, new ReLu(), featureDimension, typeNumber, this, regularModel, regular, coreNumber);
            hiddenNerves.add(hiddenNerve);
            this.hiddenNerveList.add(hiddenNerve);
        }
        ArrayList<Nerve> outNerves = new ArrayList<Nerve>();
        for (int i = 0; i < typeNumber; ++i) {
            OutNerve outNerve = new OutNerve(i + 1, studyPoint, featureDimension, featureDimension, typeNumber, softMax, regularModel, regular, coreNumber);
            outNerve.connectFather(hiddenNerves);
            outNerves.add(outNerve);
            this.outNerveList.add(outNerve);
        }
        for (Nerve nerve : hiddenNerves) {
            nerve.connect(outNerves);
        }
    }

    public void sendParameter(long eventID, Matrix feature, boolean isStudy, OutBack outBack, List<Integer> E, boolean outAllPro) throws Exception {
        for (HiddenNerve hiddenNerve : this.hiddenNerveList) {
            hiddenNerve.postMessage(eventID, feature, isStudy, outBack, E, outAllPro);
        }
    }

    public void backError(long eventID, Matrix errorMatrix) throws Exception {
        ++this.backNumber;
        this.allError = this.allError == null ? errorMatrix : this.matrixOperation.add(errorMatrix, this.allError);
        if (this.backNumber == this.featureDimension) {
            this.backNumber = 0;
            Matrix error = this.allError.getSonOfMatrix(0, 0, this.allError.getX(), this.allError.getY() - 1);
            this.allError = null;
            this.lastCodecBlock.backError(eventID, error);
        }
    }
}

