/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.voice;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class WaveFile {
    public final int NOT_SPECIFIED = -1;
    public final int INT_SIZE = 4;
    private int sampleSize = -1;
    private long framesCount = -1L;
    private int sampleRate = -1;
    private int channelsNum;
    private byte[] data;
    private AudioInputStream ais;
    private AudioFormat af;
    private Clip clip;
    private boolean canPlay;

    public WaveFile(File file) throws UnsupportedAudioFileException, IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        this.ais = AudioSystem.getAudioInputStream(file);
        this.af = this.ais.getFormat();
        this.framesCount = this.ais.getFrameLength();
        this.sampleRate = (int)this.af.getSampleRate();
        this.sampleSize = this.af.getSampleSizeInBits() / 8;
        this.channelsNum = this.af.getChannels();
        long dataLength = this.framesCount * (long)this.af.getSampleSizeInBits() * (long)this.af.getChannels() / 8L;
        this.data = new byte[(int)dataLength];
        this.ais.read(this.data);
        AudioInputStream aisForPlay = AudioSystem.getAudioInputStream(file);
        try {
            this.clip = AudioSystem.getClip();
            this.clip.open(aisForPlay);
            this.clip.setFramePosition(0);
            this.canPlay = true;
        }
        catch (LineUnavailableException e) {
            this.canPlay = false;
            System.out.println("I can play only 8bit and 16bit music.");
        }
    }

    public boolean isCanPlay() {
        return this.canPlay;
    }

    public void play() {
        this.clip.start();
    }

    public void stop() {
        this.clip.stop();
    }

    public AudioFormat getAudioFormat() {
        return this.af;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public float getDurationTime() {
        return (float)this.getFramesCount() / this.getAudioFormat().getFrameRate();
    }

    public long getFramesCount() {
        return this.framesCount;
    }

    public int getSampleInt(int sampleNumber) {
        if (sampleNumber < 0 || sampleNumber >= this.data.length / this.sampleSize) {
            throw new IllegalArgumentException("sample number can't be < 0 or >= data.length/" + this.sampleSize);
        }
        byte[] sampleBytes = new byte[4];
        for (int i = 0; i < this.sampleSize; ++i) {
            sampleBytes[i] = this.data[sampleNumber * this.sampleSize * this.channelsNum + i];
        }
        int sample = ByteBuffer.wrap(sampleBytes).order(ByteOrder.LITTLE_ENDIAN).getInt();
        return sample;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public Clip getClip() {
        return this.clip;
    }
}

