/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.yolo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.dromara.easyai.entity.Box;
import org.dromara.easyai.entity.ThreeChannelMatrix;
import org.dromara.easyai.function.ReLu;
import org.dromara.easyai.i.OutBack;
import org.dromara.easyai.nerveCenter.NerveManager;
import org.dromara.easyai.nerveEntity.SensoryNerve;
import org.dromara.easyai.tools.NMS;
import org.dromara.easyai.tools.Picture;
import org.dromara.easyai.yolo.OutBox;
import org.dromara.easyai.yolo.PositionBack;
import org.dromara.easyai.yolo.TypeBody;
import org.dromara.easyai.yolo.TypeModel;
import org.dromara.easyai.yolo.YoloBody;
import org.dromara.easyai.yolo.YoloConfig;
import org.dromara.easyai.yolo.YoloMessage;
import org.dromara.easyai.yolo.YoloModel;
import org.dromara.easyai.yolo.YoloSample;
import org.dromara.easyai.yolo.YoloTypeBack;

public class FastYolo {
    private final YoloConfig yoloConfig;
    private final NerveManager typeNerveManager;
    private final List<TypeBody> typeBodies = new ArrayList<TypeBody>();
    private final int winWidth;
    private final int winHeight;
    private final int widthStep;
    private final int heightStep;

    public FastYolo(YoloConfig yoloConfig) throws Exception {
        float stepReduce = yoloConfig.getCheckStepReduce();
        this.yoloConfig = yoloConfig;
        this.winHeight = yoloConfig.getWindowHeight();
        this.winWidth = yoloConfig.getWindowWidth();
        this.widthStep = (int)((float)this.winWidth * stepReduce);
        this.heightStep = (int)((float)this.winHeight * stepReduce);
        if (!(stepReduce <= 1.0f) || this.widthStep <= 0 || this.heightStep <= 0) {
            throw new Exception("The stepReduce must be (0,1] and widthStep ,heightStep must Greater than 0");
        }
        this.typeNerveManager = new NerveManager(3, yoloConfig.getHiddenNerveNub(), yoloConfig.getTypeNub() + 1, 1, new ReLu(), yoloConfig.getStudyRate(), yoloConfig.getRegularModel(), yoloConfig.getRegular(), yoloConfig.getCoreNumber());
        this.typeNerveManager.initImageNet(yoloConfig.getChannelNo(), yoloConfig.getKernelSize(), this.winHeight, this.winWidth, true, yoloConfig.isShowLog(), yoloConfig.getStudyRate(), new ReLu(), yoloConfig.getMinFeatureValue(), yoloConfig.getOneConvStudy(), yoloConfig.isNorm());
    }

    private void insertYoloBody(YoloBody yoloBody) throws Exception {
        boolean here = false;
        for (TypeBody typeBody : this.typeBodies) {
            if (typeBody.getTypeID() != yoloBody.getTypeID()) continue;
            here = true;
            typeBody.insertYoloBody(yoloBody);
            break;
        }
        if (!here) {
            TypeBody typeBody = new TypeBody(this.yoloConfig, this.winWidth, this.winHeight);
            typeBody.setTypeID(yoloBody.getTypeID());
            typeBody.setMappingID(this.typeBodies.size() + 1);
            typeBody.insertYoloBody(yoloBody);
            this.typeBodies.add(typeBody);
        }
    }

    public void insertModel(YoloModel yoloModel) throws Exception {
        this.typeNerveManager.insertConvModel(yoloModel.getTypeModel());
        List<TypeModel> typeModels = yoloModel.getTypeModels();
        for (TypeModel typeModel : typeModels) {
            TypeBody typeBody = new TypeBody(this.yoloConfig, this.winWidth, this.winHeight);
            typeBody.setTypeID(typeModel.getTypeID());
            typeBody.setMappingID(typeModel.getMappingID());
            typeBody.setMinWidth(typeModel.getMinWidth());
            typeBody.setMinHeight(typeModel.getMinHeight());
            typeBody.setMaxWidth(typeModel.getMaxWidth());
            typeBody.setMaxHeight(typeModel.getMaxHeight());
            typeBody.getPositonNerveManager().insertConvModel(typeModel.getPositionModel());
            this.typeBodies.add(typeBody);
        }
    }

    public YoloModel getModel() throws Exception {
        YoloModel yoloModel = new YoloModel();
        yoloModel.setTypeModel(this.typeNerveManager.getConvModel());
        ArrayList<TypeModel> typeModels = new ArrayList<TypeModel>();
        for (TypeBody typeBody : this.typeBodies) {
            TypeModel typeModel = new TypeModel();
            typeModel.setTypeID(typeBody.getTypeID());
            typeModel.setMappingID(typeBody.getMappingID());
            typeModel.setMinHeight(typeBody.getMinHeight());
            typeModel.setMinWidth(typeBody.getMinWidth());
            typeModel.setMaxWidth(typeBody.getMaxWidth());
            typeModel.setMaxHeight(typeBody.getMaxHeight());
            typeModel.setPositionModel(typeBody.getPositonNerveManager().getConvModel());
            typeModels.add(typeModel);
        }
        yoloModel.setTypeModels(typeModels);
        return yoloModel;
    }

    private Box getBox(int i, int j, int maxX, int maxY, PositionBack positionBack, TypeBody typeBody) throws Exception {
        float zhou = this.winHeight + this.winWidth;
        Box box = new Box();
        float centerX = (float)i - positionBack.getDistX() * zhou;
        float centerY = (float)j - positionBack.getDistY() * zhou;
        int width = (int)typeBody.getRealWidth(positionBack.getWidth());
        int height = (int)typeBody.getRealHeight(positionBack.getHeight());
        int realX = (int)(centerX - (float)(height / 2));
        int realY = (int)(centerY - (float)(width / 2));
        if (realX < 0) {
            realX = 0;
        }
        if (realY < 0) {
            realY = 0;
        }
        if (realX + height > maxX) {
            realX = maxX - height;
        }
        if (realY + width > maxY) {
            realY = maxY - width;
        }
        box.setX(realX);
        box.setY(realY);
        box.setxSize(height);
        box.setySize(width);
        box.setConfidence(positionBack.getTrust());
        box.setTypeID(typeBody.getTypeID());
        return box;
    }

    private List<OutBox> getOutBoxList(List<Box> boxes) {
        ArrayList<OutBox> outBoxes = new ArrayList<OutBox>();
        for (Box box : boxes) {
            OutBox outBox = new OutBox();
            outBox.setX(box.getY());
            outBox.setY(box.getX());
            outBox.setHeight(box.getxSize());
            outBox.setWidth(box.getySize());
            outBox.setTypeID(String.valueOf(box.getTypeID()));
            outBoxes.add(outBox);
        }
        return outBoxes;
    }

    public List<OutBox> look(ThreeChannelMatrix th, long eventID) throws Exception {
        int x = th.getX();
        int y = th.getY();
        ArrayList<Box> boxes = new ArrayList<Box>();
        NMS nms = new NMS(this.yoloConfig.getIouTh());
        float pth = this.yoloConfig.getPth();
        for (int i = 0; i <= x - this.winHeight; i += this.heightStep) {
            for (int j = 0; j <= y - this.winWidth; j += this.widthStep) {
                YoloTypeBack yoloTypeBack = new YoloTypeBack();
                PositionBack positionBack = new PositionBack();
                ThreeChannelMatrix myTh = th.cutChannel(i, j, this.winHeight, this.winWidth);
                this.study(eventID, this.typeNerveManager.getConvInput(), myTh, false, null, yoloTypeBack);
                int mappingID = yoloTypeBack.getId();
                if (mappingID == this.typeBodies.size() + 1 || !(yoloTypeBack.getOut() > pth)) continue;
                TypeBody typeBody = this.getTypeBodyByMappingID(mappingID);
                SensoryNerve convInput = typeBody.getPositonNerveManager().getConvInput();
                this.study(eventID, convInput, myTh, false, null, positionBack);
                boxes.add(this.getBox(i, j, x, y, positionBack, typeBody));
            }
        }
        if (boxes.isEmpty()) {
            return null;
        }
        return this.getOutBoxList(nms.start(boxes));
    }

    public void toStudy(List<YoloSample> yoloSamples) throws Exception {
        for (YoloSample yoloSample : yoloSamples) {
            List<YoloBody> yoloBodies = yoloSample.getYoloBodies();
            for (YoloBody yoloBody : yoloBodies) {
                this.insertYoloBody(yoloBody);
            }
        }
        int enh = this.yoloConfig.getEnhance();
        for (int i = 0; i < enh; ++i) {
            System.out.println("\u7b2c===========================" + i + "\u6b21\u5171" + enh + "\u6b21");
            int index = 0;
            for (YoloSample yoloSample : yoloSamples) {
                System.out.println("index:" + ++index + ",size:" + yoloSamples.size());
                this.study(yoloSample);
            }
        }
    }

    private Box changeBox(YoloBody yoloBody) {
        Box box = new Box();
        box.setX(yoloBody.getY());
        box.setY(yoloBody.getX());
        box.setTypeID(yoloBody.getTypeID());
        box.setxSize(yoloBody.getHeight());
        box.setySize(yoloBody.getWidth());
        return box;
    }

    private YoloMessage containSample(List<Box> boxes, Box testBox, NMS nms, int i, int j) {
        float containIouTh = this.yoloConfig.getContainIouTh();
        float maxIou = 0.0f;
        Box myBox = null;
        YoloMessage yoloMessage = new YoloMessage();
        for (Box box : boxes) {
            float iou = nms.getSRatio(testBox, box, false);
            if (!(iou > containIouTh) || !(iou > maxIou)) continue;
            maxIou = iou;
            myBox = box;
        }
        if (myBox != null) {
            int centerX = myBox.getX() + myBox.getxSize() / 2;
            int centerY = myBox.getY() + myBox.getySize() / 2;
            float zhou = this.winHeight + this.winWidth;
            float distX = (float)(i - centerX) / zhou;
            float distY = (float)(j - centerY) / zhou;
            TypeBody typeBody = this.getTypeBodyByTypeID(myBox.getTypeID());
            float height = typeBody.getOneHeight(myBox.getxSize());
            float width = typeBody.getOneWidth(myBox.getySize());
            float trust = 0.0f;
            if (centerX >= i && centerX <= i + this.winHeight && centerY >= j && centerY <= j + this.winWidth) {
                trust = 1.0f;
            }
            yoloMessage.setWidth(width);
            yoloMessage.setHeight(height);
            yoloMessage.setDistX(distX);
            yoloMessage.setDistY(distY);
            yoloMessage.setTrust(trust);
            yoloMessage.setMappingID(typeBody.getMappingID());
            yoloMessage.setTypeBody(typeBody);
        } else {
            yoloMessage.setBackGround(true);
            yoloMessage.setMappingID(this.typeBodies.size() + 1);
        }
        return yoloMessage;
    }

    private List<Box> getBoxes(List<YoloBody> yoloBodies) {
        ArrayList<Box> boxes = new ArrayList<Box>();
        for (YoloBody yoloBody : yoloBodies) {
            boxes.add(this.changeBox(yoloBody));
        }
        return boxes;
    }

    private List<YoloMessage> anySort(List<YoloMessage> sentences) {
        Random random = new Random();
        ArrayList<YoloMessage> sent = new ArrayList<YoloMessage>();
        int time = sentences.size();
        for (int i = 0; i < time; ++i) {
            int size = sentences.size();
            int index = random.nextInt(size);
            sent.add(sentences.get(index));
            sentences.remove(index);
        }
        return sent;
    }

    private void study(YoloSample yoloSample) throws Exception {
        List<YoloBody> yoloBodies = yoloSample.getYoloBodies();
        List<Box> boxes = this.getBoxes(yoloBodies);
        String url = yoloSample.getLocationURL();
        NMS nms = new NMS(this.yoloConfig.getIouTh());
        ThreeChannelMatrix pic = Picture.getThreeMatrix(url, false);
        ArrayList<YoloMessage> yoloMessageList = new ArrayList<YoloMessage>();
        float stepReduce = this.yoloConfig.getStepReduce();
        int stepX = (int)((float)this.winHeight * stepReduce);
        int stepY = (int)((float)this.winWidth * stepReduce);
        if (stepX < 1 || stepY < 1) {
            throw new Exception("\u8bad\u7ec3\u6b65\u957f\u6536\u7f29\u540e\u6b65\u957f\u5fc5\u987b\u5927\u4e8e0");
        }
        for (int i = 0; i <= pic.getX() - this.winHeight; i += stepX) {
            for (int j = 0; j <= pic.getY() - this.winWidth; j += stepY) {
                Box testBox = new Box();
                testBox.setX(i);
                testBox.setY(j);
                testBox.setxSize(this.winHeight);
                testBox.setySize(this.winWidth);
                YoloMessage yoloMessage = this.containSample(boxes, testBox, nms, i, j);
                yoloMessage.setPic(pic.cutChannel(i, j, this.winHeight, this.winWidth));
                yoloMessageList.add(yoloMessage);
            }
        }
        if (!yoloMessageList.isEmpty()) {
            this.studyImage(this.anySort(yoloMessageList));
        }
    }

    private TypeBody getTypeBodyByMappingID(int mappingID) {
        TypeBody ty = null;
        for (TypeBody yb : this.typeBodies) {
            if (yb.getMappingID() != mappingID) continue;
            ty = yb;
            break;
        }
        return ty;
    }

    private TypeBody getTypeBodyByTypeID(int typeID) {
        TypeBody ty = null;
        for (TypeBody yb : this.typeBodies) {
            if (yb.getTypeID() != typeID) continue;
            ty = yb;
            break;
        }
        return ty;
    }

    private void studyImage(List<YoloMessage> yoloMessageList) throws Exception {
        for (YoloMessage yoloMessage : yoloMessageList) {
            HashMap<Integer, Float> typeE = new HashMap<Integer, Float>();
            ThreeChannelMatrix small = yoloMessage.getPic();
            int mappingID = yoloMessage.getMappingID();
            typeE.put(mappingID, Float.valueOf(1.0f));
            this.study(1L, this.typeNerveManager.getConvInput(), small, true, typeE, null);
            if (yoloMessage.isBackGround()) continue;
            HashMap<Integer, Float> positionE = new HashMap<Integer, Float>();
            positionE.put(1, Float.valueOf(yoloMessage.getDistX()));
            positionE.put(2, Float.valueOf(yoloMessage.getDistY()));
            positionE.put(3, Float.valueOf(yoloMessage.getWidth()));
            positionE.put(4, Float.valueOf(yoloMessage.getHeight()));
            positionE.put(5, Float.valueOf(yoloMessage.getTrust()));
            NerveManager position = yoloMessage.getTypeBody().getPositonNerveManager();
            this.study(1L, position.getConvInput(), small, true, positionE, null);
        }
    }

    private void study(long eventID, SensoryNerve convInput, ThreeChannelMatrix feature, boolean isStudy, Map<Integer, Float> E, OutBack back) throws Exception {
        convInput.postThreeChannelMatrix(eventID, feature, isStudy, E, back, false);
    }
}

