/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.yolo;

import java.util.ArrayList;
import java.util.List;
import org.dromara.easyai.function.ReLu;
import org.dromara.easyai.function.Tanh;
import org.dromara.easyai.nerveCenter.NerveManager;
import org.dromara.easyai.yolo.YoloBody;
import org.dromara.easyai.yolo.YoloConfig;

public class TypeBody {
    private int typeID;
    private int mappingID;
    private int maxWidth = 0;
    private int maxHeight = 0;
    private int minWidth = -1;
    private int minHeight = -1;
    private int winWidth = 0;
    private int winHeight = 0;
    private final NerveManager positonNerveManager;
    private List<YoloBody> yoloBodies = new ArrayList<YoloBody>();

    public int getWinWidth() {
        return this.winWidth;
    }

    public int getWinHeight() {
        return this.winHeight;
    }

    public NerveManager getPositonNerveManager() {
        return this.positonNerveManager;
    }

    public TypeBody(YoloConfig yoloConfig, int minWinWidth, int minWinHeight) throws Exception {
        this.winWidth = minWinWidth;
        this.winHeight = minWinHeight;
        this.positonNerveManager = new NerveManager(3, yoloConfig.getHiddenNerveNub(), 5, 1, new Tanh(), yoloConfig.getStudyRate(), yoloConfig.getRegularModel(), yoloConfig.getRegular(), yoloConfig.getCoreNumber());
        this.positonNerveManager.initImageNet(yoloConfig.getChannelNo(), yoloConfig.getKernelSize(), minWinHeight, minWinWidth, false, yoloConfig.isShowLog(), yoloConfig.getStudyRate(), new ReLu(), yoloConfig.getMinFeatureValue(), yoloConfig.getOneConvStudy(), yoloConfig.isNorm());
    }

    public float getRealWidth(float width) {
        if (this.maxWidth == this.minWidth) {
            return this.maxWidth;
        }
        return (float)(this.maxWidth - this.minWidth) * width + (float)this.minWidth;
    }

    public float getRealHeight(float height) {
        if (this.maxHeight == this.minHeight) {
            return this.maxHeight;
        }
        return (float)(this.maxHeight - this.minHeight) * height + (float)this.minHeight;
    }

    public float getOneWidth(int width) {
        if (this.maxWidth == this.minWidth) {
            return 1.0f;
        }
        return (float)(width - this.minWidth) / (float)(this.maxWidth - this.minWidth);
    }

    public float getOneHeight(int height) {
        if (this.maxHeight == this.minHeight) {
            return 1.0f;
        }
        return (float)(height - this.minHeight) / (float)(this.maxHeight - this.minHeight);
    }

    public void insertYoloBody(YoloBody yoloBody) {
        if (yoloBody.getWidth() > this.maxWidth) {
            this.maxWidth = yoloBody.getWidth();
        }
        if (yoloBody.getHeight() > this.maxHeight) {
            this.maxHeight = yoloBody.getHeight();
        }
        if (this.minWidth < 0 || yoloBody.getWidth() < this.minWidth) {
            this.minWidth = yoloBody.getWidth();
        }
        if (this.minHeight < 0 || yoloBody.getHeight() < this.minHeight) {
            this.minHeight = yoloBody.getHeight();
        }
        this.yoloBodies.add(yoloBody);
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public void setMinWidth(int minWidth) {
        this.minWidth = minWidth;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
    }

    public List<YoloBody> getYoloBodies() {
        return this.yoloBodies;
    }

    public void setYoloBodies(List<YoloBody> yoloBodies) {
        this.yoloBodies = yoloBodies;
    }

    public int getTypeID() {
        return this.typeID;
    }

    public void setTypeID(int typeID) {
        this.typeID = typeID;
    }

    public int getMappingID() {
        return this.mappingID;
    }

    public void setMappingID(int mappingID) {
        this.mappingID = mappingID;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }
}

